/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicOverloadable;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcPath {
    private final int mySize;
    private final String myDisambiguator;
    private final List<String> myNames;
    private final List<String> myKinds;

    public DbSrcPath(@NotNull List<String> names, @NotNull List<String> kinds, @Nullable String disambiguator) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/database/dataSource/srcStorage/DbSrcPath", "<init>"));
        }
        if (kinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kinds", "com/intellij/database/dataSource/srcStorage/DbSrcPath", "<init>"));
        }
        this(names, kinds, names.size(), disambiguator);
    }

    public DbSrcPath(@NotNull List<String> names, @NotNull List<String> kinds, int size, @Nullable String disambiguator) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/database/dataSource/srcStorage/DbSrcPath", "<init>"));
        }
        if (kinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kinds", "com/intellij/database/dataSource/srcStorage/DbSrcPath", "<init>"));
        }
        if (size > names.size() || size > kinds.size()) {
            throw new AssertionError((Object)"names and kinds less than size");
        }
        this.mySize = size;
        this.myNames = names;
        this.myKinds = kinds;
        this.myDisambiguator = disambiguator;
    }

    public int size() {
        return this.mySize;
    }

    public String getName() {
        return this.myNames.get(this.mySize - 1);
    }

    public String getKind() {
        return this.myKinds.get(this.mySize - 1);
    }

    public String getDisambiguator() {
        return this.myDisambiguator;
    }

    public String name(int i2) {
        return this.myNames.get(i2);
    }

    public String kind(int i2) {
        return this.myKinds.get(i2);
    }

    public DbSrcPath getPath(int i2) {
        if (i2 >= this.mySize) {
            throw new IndexOutOfBoundsException();
        }
        if (i2 + 1 == this.mySize) {
            return this;
        }
        return new DbSrcPath(this.myNames, this.myKinds, i2 + 1, null);
    }

    @NotNull
    public Iterable<String> names() {
        JBIterable jBIterable = JBIterable.from(this.myNames).take(this.mySize);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcPath", "names"));
        }
        return jBIterable;
    }

    @NotNull
    public static DbSrcPath of(@NotNull DasObject obj) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/dataSource/srcStorage/DbSrcPath", "of"));
        }
        ArrayList names = ContainerUtil.newArrayList();
        ArrayList kinds = ContainerUtil.newArrayList();
        for (DasObject tmp = obj; tmp != null && tmp.getKind() != ObjectKind.NONE && tmp.getKind() != ObjectKind.ROOT; tmp = tmp.getDbParent()) {
            names.add(tmp.getName());
            kinds.add(tmp.getKind().code());
        }
        Collections.reverse(names);
        Collections.reverse(kinds);
        DbSrcPath dbSrcPath = new DbSrcPath(names, kinds, DbSrcPath.getDisambiguator(obj));
        if (dbSrcPath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcPath", "of"));
        }
        return dbSrcPath;
    }

    @Nullable
    public static String getDisambiguator(@NotNull DasObject obj) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/dataSource/srcStorage/DbSrcPath", "getDisambiguator"));
        }
        BasicOverloadable overloadable = (BasicOverloadable)ObjectUtils.tryCast((Object)DbImplUtil.unwrap(obj), BasicOverloadable.class);
        return overloadable != null ? StringUtil.trimStart((String)overloadable.identity(true), (String)obj.getName()) : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DbSrcPath path = (DbSrcPath)o;
        if (this.mySize != path.mySize) {
            return false;
        }
        if (this.myDisambiguator != null ? !this.myDisambiguator.equals(path.myDisambiguator) : path.myDisambiguator != null) {
            return false;
        }
        if (!DbSrcPath.eq(this.myNames, path.myNames, this.mySize)) {
            return false;
        }
        return DbSrcPath.eq(this.myKinds, path.myKinds, this.mySize);
    }

    public int hashCode() {
        int result = this.mySize;
        result = 31 * result + (this.myDisambiguator != null ? this.myDisambiguator.hashCode() : 0);
        result = 31 * result + DbSrcPath.hash(this.myNames, this.mySize);
        result = 31 * result + DbSrcPath.hash(this.myKinds, this.mySize);
        return result;
    }

    public String toString() {
        return StringUtil.join((Iterable)JBIterable.generate((Object)0, i2 -> i2 + 1).take(this.size()).transform(i2 -> this.myNames.get((int)i2) + ":" + this.myKinds.get((int)i2)), (String)", ") + "[" + this.getDisambiguator() + "]";
    }

    private static <T> boolean eq(List<T> a, List<T> b, int sz) {
        if (a == null || b == null || a == b) {
            return a == b;
        }
        for (int i2 = 0; i2 < sz; ++i2) {
            if (Comparing.equal(a.get(i2), b.get(i2))) continue;
            return false;
        }
        return true;
    }

    private static <T> int hash(List<T> a, int sz) {
        if (a == null) {
            return 0;
        }
        int res = 0;
        for (int i2 = 0; i2 < sz; ++i2) {
            res = 31 * res + Comparing.hashcode(a.get(i2));
        }
        return res;
    }
}

