/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.TypesRegistry;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.IdeaActionButtonLook;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.FocusListener;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ParamEditorBase<T extends JComponent>
implements TypesRegistry.ParamEditor {
    private static final Key<ParamEditorBase> PARAM_EDITOR = Key.create((String)"PARAM_EDITOR");
    private final T myEditorComponent;
    private final JComponent myComponent;
    private final String myCaption;
    private final TypesRegistry.ParamEditor.FieldSize myFieldSize;
    private final PresentationFactory myPresentationFactory;
    private final DataInterchange myInterchange;
    private Runnable myChangeListener;

    public ParamEditorBase(@NotNull T editorComponent, @NotNull DataInterchange interchange, @NotNull TypesRegistry.ParamEditor.FieldSize fieldSize, @Nullable String caption, AnAction ... actions) {
        if (editorComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorComponent", "com/intellij/database/dataSource/url/ui/ParamEditorBase", "<init>"));
        }
        if (interchange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interchange", "com/intellij/database/dataSource/url/ui/ParamEditorBase", "<init>"));
        }
        if (fieldSize == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldSize", "com/intellij/database/dataSource/url/ui/ParamEditorBase", "<init>"));
        }
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/database/dataSource/url/ui/ParamEditorBase", "<init>"));
        }
        this.myEditorComponent = editorComponent;
        this.myInterchange = interchange;
        this.myFieldSize = fieldSize;
        this.myCaption = caption;
        this.myComponent = new Box(0);
        this.myComponent.putClientProperty(PARAM_EDITOR, this);
        this.myComponent.add((Component)this.myEditorComponent);
        this.myPresentationFactory = new PresentationFactory();
        for (AnAction action : actions) {
            this.addButton(action);
        }
    }

    public void dispose() {
    }

    @Override
    @Nullable
    public String getCaption() {
        return this.myCaption;
    }

    @Override
    public TypesRegistry.ParamEditor.FieldSize getFieldSize() {
        return this.myFieldSize;
    }

    @Override
    public void addFocusListener(@NotNull FocusListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/dataSource/url/ui/ParamEditorBase", "addFocusListener"));
        }
        ((Component)this.getEditorComponent()).addFocusListener(listener);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/ParamEditorBase", "getComponent"));
        }
        return jComponent;
    }

    @Override
    public void setChangeListener(@NotNull Runnable callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/dataSource/url/ui/ParamEditorBase", "setChangeListener"));
        }
        this.myChangeListener = callback;
    }

    @NotNull
    public T getEditorComponent() {
        T t = this.myEditorComponent;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/ParamEditorBase", "getEditorComponent"));
        }
        return t;
    }

    protected void fireChanged() {
        if (this.myChangeListener != null) {
            this.myChangeListener.run();
        }
    }

    public ActionButton addButton(@NotNull AnAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/database/dataSource/url/ui/ParamEditorBase", "addButton"));
        }
        ActionButton button = new ActionButton(action, this.myPresentationFactory.getPresentation(action), "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){

            protected DataContext getDataContext() {
                DataContext context = super.getDataContext();
                DataManager.getInstance().saveInDataContext(context, PARAM_EDITOR, (Object)ParamEditorBase.this);
                return context;
            }
        };
        button.setMaximumSize(ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        button.setLook((ActionButtonLook)new IdeaActionButtonLook(){

            public void paintBorder(Graphics g, JComponent component, int state) {
                if (state == 0) {
                    this.paintBorder(g, component.getSize(), state);
                    return;
                }
                super.paintBorder(g, component, state);
            }
        });
        this.myComponent.add((Component)button);
        return button;
    }

    @NotNull
    public DataInterchange getInterchange() {
        DataInterchange dataInterchange = this.myInterchange;
        if (dataInterchange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/ParamEditorBase", "getInterchange"));
        }
        return dataInterchange;
    }

    static Color getBackground(boolean active) {
        return active ? UIUtil.getTextFieldBackground() : UIUtil.getPanelBackground();
    }

    public static class FMSaveAction
    extends ParamActionBase {
        private final FileSaverDescriptor myDesc;

        public FMSaveAction(@NotNull FileSaverDescriptor desc) {
            if (desc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "com/intellij/database/dataSource/url/ui/ParamEditorBase$FMSaveAction", "<init>"));
            }
            super("Save", "Select file", IconUtil.getAddIcon());
            this.myDesc = desc;
        }

        public void actionPerformed(AnActionEvent e) {
            ParamEditorBase editor = FMSaveAction.getEditor(e);
            if (editor == null) {
                return;
            }
            VirtualFile curFile = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)editor.getText()));
            FileSaverDialog chooser = FileChooserFactory.getInstance().createSaveFileDialog(this.myDesc, (Component)editor.getComponent());
            VirtualFileWrapper file = chooser.save(curFile == null ? null : curFile.getParent(), curFile == null ? null : curFile.getName());
            if (file != null) {
                editor.setText(file.getFile().getPath());
            }
        }
    }

    public static class FMChooseAction
    extends ParamActionBase {
        private final FileChooserDescriptor myDesc;

        public FMChooseAction(@NotNull FileChooserDescriptor desc) {
            if (desc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "com/intellij/database/dataSource/url/ui/ParamEditorBase$FMChooseAction", "<init>"));
            }
            super("Open", "Select file", AllIcons.General.Ellipsis);
            this.myDesc = desc;
        }

        public void actionPerformed(AnActionEvent e) {
            ParamEditorBase editor = FMChooseAction.getEditor(e);
            if (editor == null) {
                return;
            }
            VirtualFile curFile = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)editor.getText()));
            VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)this.myDesc, (Component)editor.getComponent(), null, (VirtualFile)curFile);
            if (file != null) {
                this.setFile(editor, file);
            }
        }

        protected void setFile(@NotNull ParamEditorBase editor, @NotNull VirtualFile file) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/dataSource/url/ui/ParamEditorBase$FMChooseAction", "setFile"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/url/ui/ParamEditorBase$FMChooseAction", "setFile"));
            }
            editor.setText(file.getPath());
        }
    }

    public static abstract class ParamActionBase
    extends DumbAwareAction {
        public ParamActionBase(String name, String tip, Icon icon) {
            super(name, tip, icon);
        }

        @Nullable
        static ParamEditorBase getEditor(AnActionEvent e) {
            return (ParamEditorBase)DataManager.getInstance().loadFromDataContext(e.getDataContext(), PARAM_EDITOR);
        }
    }
}

