/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.DatabaseNotifications;
import com.intellij.database.dbimport.ImportErrorHandler;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.ImporterGenerator;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.remote.dbimport.BatchRecords;
import com.intellij.database.remote.jdbc.impl.RemoteBatchPreparedStatement;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.view.AbstractDatabaseModifier;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.sql.Connection;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.atomic.DoubleAdder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportDatabaseModifier
extends AbstractDatabaseModifier {
    private static final Logger LOG = Logger.getInstance(ImportDatabaseModifier.class);
    private static final double UNSET = -1.0;
    private static final String INDICATOR_TITLE = "Importing Data...";
    private final AbstractDatabaseModifier.QueryExecutor myExecutor;

    public ImportDatabaseModifier(@NotNull DbDataSource dataSource, @NotNull ImportInfo info, @NotNull Project project, @NotNull DatabaseDialectEx dialectEx, @NotNull ReaderTask.Input reader, @Nullable DasNamespace defaultNs) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dbimport/ImportDatabaseModifier", "<init>"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportDatabaseModifier", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportDatabaseModifier", "<init>"));
        }
        if (dialectEx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialectEx", "com/intellij/database/dbimport/ImportDatabaseModifier", "<init>"));
        }
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/dbimport/ImportDatabaseModifier", "<init>"));
        }
        super(dataSource, defaultNs, INDICATOR_TITLE);
        this.myExecutor = new ImportExecutor(info, project, dialectEx, (DatabaseSystem)dataSource, reader);
    }

    @Override
    @NotNull
    protected AbstractDatabaseModifier.QueryExecutor getExecutor() {
        AbstractDatabaseModifier.QueryExecutor queryExecutor = this.myExecutor;
        if (queryExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseModifier", "getExecutor"));
        }
        return queryExecutor;
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }

    public static abstract class IndicatorUpdater {
        protected final ProgressIndicator myIndicator;
        protected final ImportInfo myInfo;
        protected final DoubleAdder mySize;
        protected double myCurrentSize;
        protected long myLines;
        protected long myStartTime;

        public IndicatorUpdater(@NotNull ProgressIndicator indicator, @NotNull DoubleAdder size, @NotNull ImportInfo info) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dbimport/ImportDatabaseModifier$IndicatorUpdater", "<init>"));
            }
            if (size == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "size", "com/intellij/database/dbimport/ImportDatabaseModifier$IndicatorUpdater", "<init>"));
            }
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportDatabaseModifier$IndicatorUpdater", "<init>"));
            }
            this.myIndicator = indicator;
            this.mySize = size;
            this.myInfo = info;
        }

        public void start() {
            this.myIndicator.setFraction(0.0);
            this.myIndicator.setText(this.getIndicatorTitle());
            this.myStartTime = System.currentTimeMillis();
            this.myIndicator.setText(this.getIndicatorTitle());
        }

        public void update(@NotNull BatchRecords records, long lines) {
            if (records == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "com/intellij/database/dbimport/ImportDatabaseModifier$IndicatorUpdater", "update"));
            }
            this.myIndicator.checkCanceled();
            double value = this.mySize.doubleValue();
            this.myCurrentSize += records.getBatchSize();
            this.myLines += lines;
            this.myIndicator.setText2(this.getStatistics());
            if (Double.compare(value, -1.0) == 0) {
                return;
            }
            this.myIndicator.setFraction(this.myCurrentSize / value);
        }

        @NotNull
        private String getIndicatorTitle() {
            DbDataSource source = (DbDataSource)ObjectUtils.notNull((Object)this.myInfo.getContext().getDataSource());
            String string = String.format("Importing %s to %s (%s)", this.myInfo.getProducerName(), this.myInfo.getTableName(), source.getName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseModifier$IndicatorUpdater", "getIndicatorTitle"));
            }
            return string;
        }

        @NotNull
        private String getStatistics() {
            long timeSpent = (System.currentTimeMillis() - this.myStartTime) / 1000L;
            if (this.myLines == 0L || timeSpent == 0L) {
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseModifier$IndicatorUpdater", "getStatistics"));
                }
                return "";
            }
            String speed = this.calculateSpeed(timeSpent);
            String string = String.format("%s %s", this.myLines, ImportUtil.pluralizeRows(this.myLines)) + (speed == null ? "" : String.format(" (%s)", speed));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseModifier$IndicatorUpdater", "getStatistics"));
            }
            return string;
        }

        @Nullable
        public abstract String calculateSpeed(long var1);
    }

    public static class ImportExecutor
    implements AbstractDatabaseModifier.QueryExecutor {
        private final ImporterGenerator myGenerator;
        private final ImportInfo myInfo;
        private final DatabaseSystem mySystem;
        private final ReaderTask.Input myInput;
        private final ImportManager myManager;
        private final ImportErrorHandler myHandler;

        public ImportExecutor(@NotNull ImportInfo info, @NotNull Project project, @NotNull DatabaseDialectEx dialectEx, @NotNull DatabaseSystem system, @NotNull ReaderTask.Input input) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "<init>"));
            }
            if (dialectEx == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialectEx", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "<init>"));
            }
            if (system == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "system", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "<init>"));
            }
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "<init>"));
            }
            this.myInput = input;
            this.mySystem = system;
            this.myManager = ImportManager.of(dialectEx, this.mySystem.getDatabaseProductVersion());
            this.myHandler = new ImportErrorHandler(project, info);
            this.myGenerator = new ImporterGenerator(info, this.myHandler, this.myManager, input);
            this.myInfo = info;
        }

        /*
         * Exception decompiling
         */
        @Override
        public boolean execute(@NotNull ProgressIndicator indicator, @NotNull Connection connection, @NotNull Project project, @NotNull ErrorHandler errorHandler) throws Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Nullable
        protected Long getInsertedRows(@Nullable RemoteBatchPreparedStatement remoteStatement) {
            try {
                return remoteStatement == null ? 0L : remoteStatement.getInsertedLinesCount();
            }
            catch (Exception exception) {
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        private Notification createNotification(@NotNull Project project, @Nullable Long timeSpent, @NotNull IndicatorUpdater updater, @Nullable Long importedCount, long errorsCount, boolean bl) {
            void error;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "createNotification"));
            }
            if (updater == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updater", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "createNotification"));
            }
            DbDataSource system = this.myInfo.getContext().getDataSource();
            String path = this.myInfo.getErrorTaskInfo().getErrorRecordsPath();
            String content = ImportExecutor.getContent(this.myInfo, timeSpent, path, updater, importedCount, errorsCount);
            NotificationType type = errorsCount > 0L || error != false ? NotificationType.ERROR : NotificationType.INFORMATION;
            Notification notification = ImportExecutor.createNotification(project, (DatabaseSystem)ObjectUtils.assertNotNull((Object)system), content, type, errorsCount > 0L ? path : null);
            if (notification == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "createNotification"));
            }
            return notification;
        }

        private static void notifyAboutInputError(@Nullable String error, @NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "notifyAboutInputError"));
            }
            if (error != null) {
                DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(error, NotificationType.ERROR).notify(project);
            }
        }

        @NotNull
        private static String getContent(@NotNull ImportInfo info, @Nullable Long timeSpent, @Nullable String path, @NotNull IndicatorUpdater updater, @Nullable Long importedCount, long errorsCount) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "getContent"));
            }
            if (updater == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updater", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "getContent"));
            }
            String string = ImportExecutor.getTitle(info) + ImportExecutor.getInsertedCount(importedCount) + ImportExecutor.getStatistics(timeSpent, updater) + ImportExecutor.getErrorsCount(path, errorsCount);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "getContent"));
            }
            return string;
        }

        @NotNull
        private static String getTitle(@NotNull ImportInfo info) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "getTitle"));
            }
            String string = String.format("%s imported to %s", info.getProducerName(), info.getTableName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "getTitle"));
            }
            return string;
        }

        @NotNull
        private static String getStatistics(@Nullable Long timeSpent, @NotNull IndicatorUpdater updater) {
            if (updater == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updater", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "getStatistics"));
            }
            String time = ImportExecutor.getTimeSpent(timeSpent);
            String speed = ImportExecutor.getSpeed(timeSpent, updater);
            boolean isTimeEmpty = StringUtil.isEmpty((String)time);
            boolean isSpeedEmpty = StringUtil.isEmpty((String)speed);
            String string = isTimeEmpty && isSpeedEmpty ? "" : (isTimeEmpty || isSpeedEmpty ? String.format(" (%s)", isTimeEmpty ? speed : time) : String.format(" (%s, %s)", time, speed));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "getStatistics"));
            }
            return string;
        }

        @NotNull
        private static String getInsertedCount(@Nullable Long importedCount) {
            String string = importedCount == null ? "" : String.format(": %s %s", String.valueOf(importedCount), ImportUtil.pluralizeRows(importedCount));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "getInsertedCount"));
            }
            return string;
        }

        @NotNull
        private static String getErrorsCount(@Nullable String path, long errorsCount) {
            String string = errorsCount > 0L ? ImportExecutor.getErrorNotification(path, errorsCount) : "";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "getErrorsCount"));
            }
            return string;
        }

        @NotNull
        private static String getErrorNotification(@Nullable String path, long errorsCount) {
            String errors = ImportUtil.pluralize("error", errorsCount);
            String string = String.format(path == null ? "\n%s %s occurs" : "\n%s %s saved to", errorsCount, errors);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "getErrorNotification"));
            }
            return string;
        }

        @NotNull
        private static String getTimeSpent(@Nullable Long timeSpent) {
            String string = timeSpent == null ? "" : StringUtil.formatDuration((long)timeSpent);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "getTimeSpent"));
            }
            return string;
        }

        @NotNull
        private static String getSpeed(@Nullable Long timeSpent, @NotNull IndicatorUpdater updater) {
            if (updater == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updater", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "getSpeed"));
            }
            if (timeSpent == null || timeSpent / 1000L == 0L) {
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "getSpeed"));
                }
                return "";
            }
            String string = StringUtil.notNullize((String)updater.calculateSpeed(timeSpent / 1000L));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "getSpeed"));
            }
            return string;
        }

        @NotNull
        private static Notification createNotification(@NotNull Project project, @NotNull DatabaseSystem system, @NotNull String content, @NotNull NotificationType type, @Nullable String path) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "createNotification"));
            }
            if (system == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "system", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "createNotification"));
            }
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "createNotification"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "createNotification"));
            }
            Notification notification = path == null ? DbUIUtil.createNotification(system, content, type) : DbUIUtil.createFileLinkNotification(project, system, content, type, path);
            if (notification == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "createNotification"));
            }
            return notification;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void execute(@NotNull Connection connection, @NotNull List<String> queries) throws Exception {
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "execute"));
            }
            if (queries == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queries", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "execute"));
            }
            Statement statement = connection.createStatement();
            try {
                for (String query : queries) {
                    statement.execute(query);
                }
            }
            finally {
                JdbcUtil.closeStatementSafe((Statement)statement);
            }
        }

        private static void executeInFinally(@NotNull Connection connection, @NotNull List<String> queries) {
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "executeInFinally"));
            }
            if (queries == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queries", "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor", "executeInFinally"));
            }
            try {
                ImportExecutor.execute(connection, queries);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

