/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.ImportType;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.util.SystemProperties;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportSettings {
    private static final String IMPORT_MODALITY = "import_modality_state";
    private static final String ERROR_DIRECTORY = "import_error_directory";
    private static final String WRITE_ERRORS = "import_write_errors";
    private static final String INSERT_AS_NULL = "insert_as_null";

    public static void store(@NotNull ImportInfo info, @NotNull DatabaseDialect dialect, @Nullable String version) {
        String path;
        boolean hasPath;
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportSettings", "store"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dbimport/ImportSettings", "store"));
        }
        PropertiesComponent props = PropertiesComponent.getInstance();
        ImportType type = info.getType();
        ImportManager manager = ImportManager.of(dialect, version);
        if (type.isTableCreated() && manager.isSupportFastMode()) {
            props.setValue(IMPORT_MODALITY, String.valueOf(info.shouldLockTable()));
        }
        boolean bl = hasPath = (path = info.getErrorTaskInfo().getErrorRecordsPath()) != null;
        if (hasPath) {
            props.setValue(ERROR_DIRECTORY, ImportSettings.getErrorDirectory(path));
        }
        props.setValue(WRITE_ERRORS, hasPath);
        props.setValue(INSERT_AS_NULL, info.isInsertAsNull());
    }

    @NotNull
    private static String getErrorDirectory(@NotNull String errorPath) {
        if (errorPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorPath", "com/intellij/database/dbimport/ImportSettings", "getErrorDirectory"));
        }
        Path path = Paths.get(errorPath, new String[0]);
        Path dir = Files.isDirectory(path, new LinkOption[0]) ? path : path.getParent();
        String string = dir == null ? SystemProperties.getUserHome() : dir.toAbsolutePath().toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportSettings", "getErrorDirectory"));
        }
        return string;
    }

    public static boolean getImportModality() {
        return ImportSettings.get(IMPORT_MODALITY);
    }

    public static boolean getWriteErrors() {
        return ImportSettings.get(WRITE_ERRORS);
    }

    public static boolean getInsertAsNull() {
        return ImportSettings.get(INSERT_AS_NULL);
    }

    @Nullable
    public static String getErrorDirectory() {
        return PropertiesComponent.getInstance().getValue(ERROR_DIRECTORY);
    }

    private static boolean get(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/dbimport/ImportSettings", "get"));
        }
        return Boolean.valueOf(PropertiesComponent.getInstance().getValue(key));
    }
}

