/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui.csv;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.ui.preview.TableCsvFormatPreview;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.dbimport.csv.CsvPreviewModel;
import com.intellij.database.dbimport.graph.GraphObservable;
import com.intellij.database.dbimport.ui.component.DataPreviewComponent;
import com.intellij.database.dbimport.ui.csv.CsvTableEditorComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ObjectUtils;
import java.nio.charset.Charset;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvPreviewComponent
extends DataPreviewComponent<CsvPreviewInfo> {
    private Disposable myPreviewDisposable;
    private final ImportAction.ImportEditorContext myContext;
    private final CsvPreviewModel myModel;
    private CsvFormat myFormat;
    private TableCsvFormatPreview myPreview;

    public CsvPreviewComponent(@NotNull ImportAction.ImportEditorContext context, @NotNull CsvPreviewModel model) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ui/csv/CsvPreviewComponent", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dbimport/ui/csv/CsvPreviewComponent", "<init>"));
        }
        super(context.getBuilder());
        this.myContext = context;
        this.myModel = model;
    }

    @NotNull
    private TableCsvFormatPreview recreatePreview() {
        if (this.myPreviewDisposable != null) {
            Disposer.dispose((Disposable)this.myPreviewDisposable);
        }
        this.myPreviewDisposable = Disposer.newDisposable();
        Disposer.register((Disposable)this.myContext.getDisposable(), (Disposable)this.myPreviewDisposable);
        TableCsvFormatPreview tableCsvFormatPreview = this.createPreview(this.myFormat);
        if (tableCsvFormatPreview == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/csv/CsvPreviewComponent", "recreatePreview"));
        }
        return tableCsvFormatPreview;
    }

    @NotNull
    private TableCsvFormatPreview createPreview(@NotNull CsvFormat selectedFormat) {
        if (selectedFormat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedFormat", "com/intellij/database/dbimport/ui/csv/CsvPreviewComponent", "createPreview"));
        }
        TableCsvFormatPreview preview = new TableCsvFormatPreview((Project)ObjectUtils.assertNotNull((Object)this.myBuilder.getContext().getProject()), selectedFormat, this.myModel.getText(), this.myPreviewDisposable);
        preview.getGrid().getDataHookup().getLoader().loadFirstPage(GridRequestSource.create(preview.getGrid(), null));
        TableCsvFormatPreview tableCsvFormatPreview = preview;
        if (tableCsvFormatPreview == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/csv/CsvPreviewComponent", "createPreview"));
        }
        return tableCsvFormatPreview;
    }

    @Override
    public void addListener(@NotNull GraphObservable.ObserverListener<?> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/dbimport/ui/csv/CsvPreviewComponent", "addListener"));
        }
    }

    @Override
    @NotNull
    public CompletionStage<DataGrid> notifyChanged(@Nullable CsvPreviewInfo object) {
        boolean isCharset = object instanceof CharsetInfo;
        boolean isFormat = object instanceof FormatInfo;
        if (!isFormat && !isCharset) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/csv/CsvPreviewComponent", "notifyChanged"));
            }
            return completableFuture;
        }
        if (isFormat) {
            CompletionStage<DataGrid> completionStage = this.formatChanged(object);
            if (completionStage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/csv/CsvPreviewComponent", "notifyChanged"));
            }
            return completionStage;
        }
        this.myModel.setCharset(((CharsetInfo)object).myCharset);
        CompletableFuture<DataGrid> completableFuture = this.resetGrid();
        if (completableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/csv/CsvPreviewComponent", "notifyChanged"));
        }
        return completableFuture;
    }

    @NotNull
    private CompletionStage<DataGrid> formatChanged(@NotNull CsvPreviewInfo object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dbimport/ui/csv/CsvPreviewComponent", "formatChanged"));
        }
        this.myFormat = object.getFormat();
        if (this.myPreview == null) {
            CompletableFuture<DataGrid> completableFuture = this.resetGrid();
            if (completableFuture == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/csv/CsvPreviewComponent", "formatChanged"));
            }
            return completableFuture;
        }
        this.myPreview.setFormat((CsvFormat)ObjectUtils.assertNotNull((Object)this.myFormat));
        CompletableFuture<DataGrid> completableFuture = CompletableFuture.completedFuture(this.getGrid());
        if (completableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/csv/CsvPreviewComponent", "formatChanged"));
        }
        return completableFuture;
    }

    @NotNull
    private CompletableFuture<DataGrid> resetGrid() {
        this.myPreview = this.recreatePreview();
        DataGrid grid = this.myPreview.getGrid();
        this.setGrid(grid);
        CompletableFuture<DataGrid> completableFuture = CompletableFuture.completedFuture(grid);
        if (completableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/csv/CsvPreviewComponent", "resetGrid"));
        }
        return completableFuture;
    }

    @Override
    public boolean dependsOn(@NotNull GraphObservable.GraphObserver<?, ?> observer) {
        if (observer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observer", "com/intellij/database/dbimport/ui/csv/CsvPreviewComponent", "dependsOn"));
        }
        return observer instanceof CsvTableEditorComponent;
    }

    public static class FormatInfo
    extends CsvPreviewInfo {
        private final CsvFormat myFormat;

        public FormatInfo(@NotNull CsvFormat format) {
            if (format == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/dbimport/ui/csv/CsvPreviewComponent$FormatInfo", "<init>"));
            }
            this.myFormat = format;
        }

        @Override
        @Nullable
        public CsvFormat getFormat() {
            return this.myFormat;
        }
    }

    public static class CharsetInfo
    extends CsvPreviewInfo {
        private final Charset myCharset;

        public CharsetInfo(@NotNull Charset charset) {
            if (charset == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/database/dbimport/ui/csv/CsvPreviewComponent$CharsetInfo", "<init>"));
            }
            this.myCharset = charset;
        }

        @Override
        @Nullable
        public Charset getCharset() {
            return this.myCharset;
        }
    }

    public static abstract class CsvPreviewInfo {
        @Nullable
        public Charset getCharset() {
            return null;
        }

        @Nullable
        public CsvFormat getFormat() {
            return null;
        }
    }
}

