/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui.database;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.graph.GraphObservable;
import com.intellij.database.dbimport.ui.ImportDatabaseTableEditor;
import com.intellij.database.dbimport.ui.component.DdlPreviewComponent;
import com.intellij.database.dbimport.ui.component.TableEditorComponent;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTableEditorComponent
extends TableEditorComponent<DataGrid> {
    public DatabaseTableEditorComponent(@NotNull ImportAction.ImportEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ui/database/DatabaseTableEditorComponent", "<init>"));
        }
        super(context);
    }

    @Override
    @NotNull
    public CompletionStage<ImportDatabaseTableEditor<?>> notifyChanged(@Nullable DataGrid object) {
        List<DataConsumer.Column> descriptors = object == null ? this.myContext.getBuilder().getProducers() : ImportUtil.getColumns(object);
        this.setEditor(this.createEditor(descriptors, object == null ? null : ImportUtil.getRows(object)));
        CompletableFuture<ImportDatabaseTableEditor<?>> completableFuture = CompletableFuture.completedFuture(this.getEditor());
        if (completableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/database/DatabaseTableEditorComponent", "notifyChanged"));
        }
        return completableFuture;
    }

    @Override
    public boolean dependsOn(@NotNull GraphObservable.GraphObserver<?, ?> observer) {
        if (observer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observer", "com/intellij/database/dbimport/ui/database/DatabaseTableEditorComponent", "dependsOn"));
        }
        return observer instanceof DdlPreviewComponent;
    }
}

