/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.google.common.collect.Iterables;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.KeywordHelper;
import com.intellij.database.dialects.TypeHelper;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasCluster;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasOperator;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTrigger;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbTable;
import com.intellij.database.schemaEditor.DasSchemaExporters;
import com.intellij.database.schemaEditor.SchemaEditor;
import com.intellij.database.schemaEditor.SchemaExporters;
import com.intellij.database.schemaEditor.generation.DdlOperations;
import com.intellij.database.schemaEditor.operations.DasDdlOperations;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDatabaseDialect
extends DatabaseDialectEx {
    protected static final String ALIAS = "t";
    private final MetaModel myMetaModel;
    private final TypeHelper myTypeHelper;
    private final KeywordHelper myKeywordHelper;
    private final Casing myCasing;
    private AtomicNotNullLazyValue<SchemaEditor> mySchemaEditor;

    protected AbstractDatabaseDialect(@NotNull MetaModel metaModel, TypeHelper typeHelper, KeywordHelper keywordHelper, Casing casing) {
        if (metaModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaModel", "com/intellij/database/dialects/AbstractDatabaseDialect", "<init>"));
        }
        this.mySchemaEditor = new AtomicNotNullLazyValue<SchemaEditor>(){

            @NotNull
            protected SchemaEditor compute() {
                SchemaEditor schemaEditor = new SchemaEditor(AbstractDatabaseDialect.this.getSchemaExporters(), AbstractDatabaseDialect.this.getDdlOperations(), AbstractDatabaseDialect.this.getDbEditorCaps());
                if (schemaEditor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect$1", "compute"));
                }
                return schemaEditor;
            }
        };
        this.myMetaModel = metaModel;
        this.myTypeHelper = typeHelper;
        this.myKeywordHelper = keywordHelper;
        this.myCasing = casing;
    }

    public boolean supportsColumnCommentsInTableDefinition() {
        return true;
    }

    @NotNull
    public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/dialects/AbstractDatabaseDialect", "getCasing"));
        }
        Casing casing = this.myCasing;
        if (casing == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "getCasing"));
        }
        return casing;
    }

    @Override
    @Contract(value="!null->!null; null->null")
    public String convertNameCatalogFormToScriptForm(String catalogName) {
        if (catalogName == null) {
            return null;
        }
        if (StringUtil.isEmpty((String)catalogName)) {
            return this.quoteIdentifierUnconditionally(catalogName);
        }
        boolean hasLowerCase = false;
        boolean hasUpperCase = false;
        boolean hasOtherChars = false;
        boolean startsWithDigit = false;
        int n = catalogName.length();
        for (int i2 = 0; i2 < n; ++i2) {
            char c = catalogName.charAt(i2);
            boolean digit = Character.isDigit(c);
            startsWithDigit |= i2 == 0 && digit;
            if ((hasLowerCase |= Character.isLowerCase(c)) && (hasUpperCase |= Character.isUpperCase(c)) && (hasOtherChars |= !digit && !Character.isLetter(c) && !this.isNameFriendlyCharacter(c))) break;
        }
        boolean toQuote = startsWithDigit || hasOtherChars || this.myCasing.plain == Case.UPPER && hasLowerCase || this.myCasing.plain == Case.LOWER && hasUpperCase || this.myKeywordHelper.isReservedKeyword(catalogName);
        return toQuote ? this.quoteIdentifierUnconditionally(catalogName) : catalogName;
    }

    protected boolean isNameFriendlyCharacter(char ch) {
        return ch == '_' || ch == '$' || ch == '#' || ch == '@';
    }

    protected String quoteIdentifierUnconditionally(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dialects/AbstractDatabaseDialect", "quoteIdentifierUnconditionally"));
        }
        int q = name.indexOf(34);
        if (q < 0) {
            return '\"' + name + '\"';
        }
        StringBuilder b = new StringBuilder(name.length() * 2);
        b.append(name);
        while (q >= 0) {
            b.insert(q + 1, '\"');
            q = b.indexOf("\"", q + 2);
        }
        b.insert(0, '\"');
        b.insert(b.length(), '\"');
        return b.toString();
    }

    @NotNull
    protected DdlOperations getDdlOperations() {
        DdlOperations ddlOperations = new DasDdlOperations.DefaultDdlOperationsBuilder(this).build();
        if (ddlOperations == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "getDdlOperations"));
        }
        return ddlOperations;
    }

    @NotNull
    protected DatabaseEditorCapabilities.ColumnEditorCaps getColumnEditorCaps(boolean existing) {
        DatabaseEditorCapabilities.ColumnEditorCaps columnEditorCaps = new DatabaseEditorCapabilities.ColumnEditorCaps(DatabaseEditorCapabilities.Capability.available(!existing || this.supportsRenameColumn()), DatabaseEditorCapabilities.Capability.supported(this.supportsColumnComment()), DatabaseEditorCapabilities.Capability.available(!existing || this.supportsAlterColumnType()), DatabaseEditorCapabilities.Capability.supported(this.supportsAutoIncrement()), DatabaseEditorCapabilities.Capability.available(!existing || this.supportsAlterColumnDefault()), DatabaseEditorCapabilities.Capability.available(!existing || this.supportsAlterColumnNull()));
        if (columnEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "getColumnEditorCaps"));
        }
        return columnEditorCaps;
    }

    @NotNull
    protected DatabaseEditorCapabilities.IndexColumnEditorCaps getIndexColumnEditorCaps(boolean existing) {
        boolean indexRecreateable = this.supportsDropIndex() && this.supportsCreateIndex();
        DatabaseEditorCapabilities.IndexColumnEditorCaps indexColumnEditorCaps = new DatabaseEditorCapabilities.IndexColumnEditorCaps(DatabaseEditorCapabilities.Capability.from(true, !existing || indexRecreateable));
        if (indexColumnEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "getIndexColumnEditorCaps"));
        }
        return indexColumnEditorCaps;
    }

    @NotNull
    protected DatabaseEditorCapabilities.IndexEditorCaps getIndexEditorCaps(boolean existing) {
        boolean indexRecreateable = this.supportsDropIndex() && this.supportsCreateIndex();
        DatabaseEditorCapabilities.IndexEditorCaps indexEditorCaps = new DatabaseEditorCapabilities.IndexEditorCaps(DatabaseEditorCapabilities.Capability.available(!existing || indexRecreateable), DatabaseEditorCapabilities.Capability.UNAVAILABLE, DatabaseEditorCapabilities.Capability.available(!existing || indexRecreateable), this.getIndexColumnEditorCaps(existing));
        if (indexEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "getIndexEditorCaps"));
        }
        return indexEditorCaps;
    }

    @NotNull
    protected DatabaseEditorCapabilities.TableKeyColumnEditorCaps getTableKeyColumnEditorCaps() {
        DatabaseEditorCapabilities.TableKeyColumnEditorCaps tableKeyColumnEditorCaps = new DatabaseEditorCapabilities.TableKeyColumnEditorCaps();
        if (tableKeyColumnEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "getTableKeyColumnEditorCaps"));
        }
        return tableKeyColumnEditorCaps;
    }

    @NotNull
    protected DatabaseEditorCapabilities.KeyEditorCaps getKeyEditorCaps(boolean existing) {
        boolean keyRecreateable = this.supportsDropConstraint() && this.supportsAddUniqueConstraint() || this.supportsDropPrimaryKey() && this.supportsAddPrimaryKey();
        DatabaseEditorCapabilities.KeyEditorCaps keyEditorCaps = new DatabaseEditorCapabilities.KeyEditorCaps(DatabaseEditorCapabilities.Capability.available(!existing || keyRecreateable), DatabaseEditorCapabilities.Capability.UNAVAILABLE, this.getTableKeyColumnEditorCaps());
        if (keyEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "getKeyEditorCaps"));
        }
        return keyEditorCaps;
    }

    @NotNull
    protected DatabaseEditorCapabilities.ForeignKeyEditorCaps getForeignKeyEditorCaps(boolean existing) {
        boolean fkRecreateable = this.supportsAddForeignKey() && this.supportsDropForeignKey();
        DatabaseEditorCapabilities.ForeignKeyEditorCaps foreignKeyEditorCaps = new DatabaseEditorCapabilities.ForeignKeyEditorCaps(DatabaseEditorCapabilities.Capability.available(!existing || fkRecreateable), DatabaseEditorCapabilities.Capability.UNAVAILABLE, DatabaseEditorCapabilities.ValuesCapability.supported(!existing || fkRecreateable, DasForeignKey.Deferrability.values()), DatabaseEditorCapabilities.ValuesCapability.supported(!existing || fkRecreateable, DasForeignKey.RuleAction.values()), DatabaseEditorCapabilities.ValuesCapability.supported(!existing || fkRecreateable, DasForeignKey.RuleAction.values()));
        if (foreignKeyEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "getForeignKeyEditorCaps"));
        }
        return foreignKeyEditorCaps;
    }

    @NotNull
    protected DatabaseEditorCapabilities.TableEditorCaps getTableEditorCaps(boolean existing) {
        DatabaseEditorCapabilities.TableEditorCaps tableEditorCaps = new DatabaseEditorCapabilities.TableEditorCaps(DatabaseEditorCapabilities.Capability.available(!existing || this.supportsRenameTable()), DatabaseEditorCapabilities.Capability.supported(this.supportsTableComment()), DatabaseEditorCapabilities.ListCapability.get(true, !existing, !existing || this.supportsAddColumn(), !existing || this.supportsDropColumn()), DatabaseEditorCapabilities.ListCapability.get(this.supportsIndexes(), false, !existing || this.supportsCreateIndex(), !existing || this.supportsDropIndex()), DatabaseEditorCapabilities.ListCapability.get(true, false, !existing || this.supportsAddForeignKey(), !existing || this.supportsDropForeignKey()), DatabaseEditorCapabilities.ListCapability.get(true, false, !existing || this.supportsAddPrimaryKey(), !existing || this.supportsDropPrimaryKey()), DatabaseEditorCapabilities.ListCapability.get(true, false, !existing || this.supportsAddUniqueConstraint(), !existing || this.supportsDropConstraint()), DatabaseEditorCapabilities.ListCapability.get(true, false, !existing || this.supportsAddUniqueConstraint(), !existing || this.supportsDropConstraint()), this.getColumnEditorCaps(false), this.getColumnEditorCaps(existing), this.getKeyEditorCaps(false), this.getKeyEditorCaps(existing), this.getIndexEditorCaps(false), this.getIndexEditorCaps(existing), this.getForeignKeyEditorCaps(false), this.getForeignKeyEditorCaps(existing));
        if (tableEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "getTableEditorCaps"));
        }
        return tableEditorCaps;
    }

    public boolean supportsTableComment() {
        return false;
    }

    @NotNull
    protected DatabaseEditorCapabilities.DbEditorCaps getDbEditorCaps() {
        DatabaseEditorCapabilities.DbEditorCaps dbEditorCaps = new DatabaseEditorCapabilities.DbEditorCaps(new DatabaseEditorCapabilities.ObjectEditorCaps(DatabaseEditorCapabilities.Capability.supported(this.supportsCreateDatabase()), DatabaseEditorCapabilities.Capability.UNSUPPORTED), new DatabaseEditorCapabilities.ObjectEditorCaps(DatabaseEditorCapabilities.Capability.supported(this.supportsRenameDatabase()), DatabaseEditorCapabilities.Capability.UNSUPPORTED), new DatabaseEditorCapabilities.ObjectEditorCaps(DatabaseEditorCapabilities.Capability.supported(this.supportsCreateSchema()), DatabaseEditorCapabilities.Capability.UNSUPPORTED), new DatabaseEditorCapabilities.ObjectEditorCaps(DatabaseEditorCapabilities.Capability.supported(this.supportsRenameSchema()), DatabaseEditorCapabilities.Capability.UNSUPPORTED), this.getTableEditorCaps(false), this.getTableEditorCaps(true));
        if (dbEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "getDbEditorCaps"));
        }
        return dbEditorCaps;
    }

    @NotNull
    protected SchemaExporters getSchemaExporters() {
        SchemaExporters schemaExporters = DasSchemaExporters.createDefaultExporters();
        if (schemaExporters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "getSchemaExporters"));
        }
        return schemaExporters;
    }

    @Override
    @NotNull
    public SchemaEditor getSchemaEditor() {
        SchemaEditor schemaEditor = (SchemaEditor)this.mySchemaEditor.getValue();
        if (schemaEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "getSchemaEditor"));
        }
        return schemaEditor;
    }

    @Override
    @NotNull
    public MetaModel getMetaModel() {
        MetaModel metaModel = this.myMetaModel;
        if (metaModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "getMetaModel"));
        }
        return metaModel;
    }

    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/database/dialects/AbstractDatabaseDialect", "isValidPlainIdentifier"));
        }
        return identifier.indexOf(this.closeQuote()) == -1;
    }

    public String quoteIdentifier(String identifier, boolean force, boolean suppress) {
        return this.quoteIdentifier(identifier, force, suppress, this.myCasing);
    }

    public String unquoteIdentifier(String identifier) {
        if (!this.isQuotedIdentifier(identifier)) {
            return identifier;
        }
        return AbstractDatabaseDialect.unescapeCharSql(identifier.substring(1, identifier.length() - 1), identifier.charAt(identifier.length() - 1));
    }

    public boolean isQuotedIdentifier(@Nullable String identifier) {
        if (StringUtil.isEmpty((String)identifier) || identifier.length() < 2) {
            return false;
        }
        return StringUtil.startsWithChar((CharSequence)identifier, (char)this.openQuote()) && StringUtil.endsWithChar((CharSequence)identifier, (char)this.closeQuote()) || this.openQuote() != '\"' && StringUtil.startsWithChar((CharSequence)identifier, (char)'\"') && StringUtil.startsWithChar((CharSequence)identifier, (char)'\"');
    }

    public String quoteIdentifier(String identifier, boolean force, boolean suppress, @NotNull Casing casing) {
        if (casing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "casing", "com/intellij/database/dialects/AbstractDatabaseDialect", "quoteIdentifier"));
        }
        if (StringUtil.isEmpty((String)identifier) || this.isQuotedIdentifier(identifier)) {
            return identifier;
        }
        force |= !this.isValidPlainIdentifier(identifier);
        if (!(force |= this.myKeywordHelper.isReservedKeyword(identifier)) && !suppress && casing.quoted == Case.EXACT && casing.plain != Case.EXACT && casing.plain != Case.MIXED) {
            Case identifierCase = Case.forString((String)identifier);
            force = identifierCase == Case.MIXED || identifierCase != casing.plain;
        }
        return force ? this.openQuote() + AbstractDatabaseDialect.escapeCharSql(identifier, this.closeQuote()) + this.closeQuote() : identifier;
    }

    @NotNull
    private static String escapeCharSql(@NotNull String s, char c) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/dialects/AbstractDatabaseDialect", "escapeCharSql"));
        }
        if (s.indexOf(c) == -1) {
            String string = s;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "escapeCharSql"));
            }
            return string;
        }
        String cs = String.valueOf(c);
        String string = StringUtil.replace((String)s, (String)cs, (String)(cs + cs));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "escapeCharSql"));
        }
        return string;
    }

    @NotNull
    private static String unescapeCharSql(@NotNull String s, char c) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/dialects/AbstractDatabaseDialect", "unescapeCharSql"));
        }
        if (s.indexOf(c) == -1) {
            String string = s;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "unescapeCharSql"));
            }
            return string;
        }
        String cs = String.valueOf(c);
        String string = StringUtil.replace((String)s, (String)(cs + cs), (String)cs);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "unescapeCharSql"));
        }
        return string;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumnAutoIncrement(@NotNull DdlBuilder builder, @NotNull DasColumn column, @NotNull String sequenceName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlAddColumnAutoIncrement"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlAddColumnAutoIncrement"));
        }
        if (sequenceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequenceName", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlAddColumnAutoIncrement"));
        }
        DdlBuilder ddlBuilder = this.sqlAddColumnAutoIncrement(builder, column);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlAddColumnAutoIncrement"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlSelectAll(@NotNull DdlBuilder builder, @NotNull DasTable dasTable, @Nullable DatabaseSystem system, @Nullable BiConsumer<String, DdlBuilder> appendWhereClause, @Nullable Consumer<DdlBuilder> orderByAppender, boolean appendRowId, int rows) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlSelectAll"));
        }
        if (dasTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dasTable", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlSelectAll"));
        }
        LimitPlace place = this.getPlaceForLimit(system);
        boolean isUnlimited = DbImplUtil.isPageSizeUnlimited(rows);
        builder.keyword("SELECT").space();
        if (!isUnlimited) {
            LimitPlace.BEGIN.appendLimit(builder, this, place, system, rows);
        }
        builder.alias(ALIAS).symbol(".").symbol("*");
        if (this.hasRowId(system) && appendRowId) {
            this.appendRowId(builder, system);
        }
        builder.space().keyword("FROM").space().qualifiedRef((DasObject)dasTable).space().alias(ALIAS);
        if (appendWhereClause != null) {
            appendWhereClause.accept(ALIAS, builder);
        }
        if (orderByAppender != null) {
            orderByAppender.consume((Object)builder);
        }
        DdlBuilder ddlBuilder = !isUnlimited ? LimitPlace.END.appendLimit(builder, this, place, system, rows) : builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlSelectAll"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlAddPrimaryKey"));
        }
        if (pk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pk", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlAddPrimaryKey"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getAddPrimaryKeySQL(builder, pk, false);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlAddPrimaryKey"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column) throws UnsupportedOperationException {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropColumn"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropColumn"));
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)column.getTable()).space();
        builder.keyword("DROP").space();
        builder.columnRef((DasObject)column);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropColumn"));
        }
        return ddlBuilder;
    }

    protected static boolean isSameName(@NotNull DasColumn from, @NotNull DasColumn to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/dialects/AbstractDatabaseDialect", "isSameName"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/dialects/AbstractDatabaseDialect", "isSameName"));
        }
        return StringUtil.equals((CharSequence)from.getName(), (CharSequence)to.getName());
    }

    protected boolean isSameType(@NotNull DasColumn from, @NotNull DasColumn to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/dialects/AbstractDatabaseDialect", "isSameType"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/dialects/AbstractDatabaseDialect", "isSameType"));
        }
        DdlBuilder tmp = new DdlBuilder().withDialect(this);
        String fromStr = tmp.type((DasTypedObject)from).getStatement();
        String toStr = tmp.clear().type((DasTypedObject)to).getStatement();
        return StringUtil.equalsIgnoreCase((CharSequence)fromStr, (CharSequence)toStr);
    }

    protected static boolean isSameDefault(@NotNull DasColumn from, @NotNull DasColumn to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/dialects/AbstractDatabaseDialect", "isSameDefault"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/dialects/AbstractDatabaseDialect", "isSameDefault"));
        }
        return StringUtil.equals((CharSequence)((CharSequence)ObjectUtils.notNull((Object)from.getDefault(), (Object)"")), (CharSequence)((CharSequence)ObjectUtils.notNull((Object)to.getDefault(), (Object)"")));
    }

    protected static boolean isSameNullability(@NotNull DasColumn from, @NotNull DasColumn to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/dialects/AbstractDatabaseDialect", "isSameNullability"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/dialects/AbstractDatabaseDialect", "isSameNullability"));
        }
        return from.isNotNull() == to.isNotNull();
    }

    protected static boolean isSameComment(@NotNull DasColumn from, @NotNull DasColumn to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/dialects/AbstractDatabaseDialect", "isSameComment"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/dialects/AbstractDatabaseDialect", "isSameComment"));
        }
        return Comparing.equal((String)from.getComment(), (String)to.getComment());
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnDefinition(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull DasColumn to, boolean forceOutput) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlAlterColumnDefinition"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlAlterColumnDefinition"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlAlterColumnDefinition"));
        }
        SplitAlterColumnSupport support = (SplitAlterColumnSupport)ObjectUtils.tryCast((Object)this, SplitAlterColumnSupport.class);
        if (support == null) {
            DdlBuilder ddlBuilder = builder;
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlAlterColumnDefinition"));
            }
            return ddlBuilder;
        }
        int before = builder.getStatements().size();
        if (!AbstractDatabaseDialect.isSameName(from, to)) {
            support.sqlAlterColumnName(builder, from, to.getName()).newStatement();
        }
        if (!this.isSameType(from, to)) {
            support.sqlAlterColumnType(builder, from, to).newStatement();
        }
        if (!AbstractDatabaseDialect.isSameDefault(from, to)) {
            support.sqlAlterColumnDefault(builder, to).newStatement();
        }
        if (!AbstractDatabaseDialect.isSameNullability(from, to)) {
            support.sqlAlterColumnNullable(builder, to).newStatement();
        }
        if (!AbstractDatabaseDialect.isSameComment(from, to)) {
            support.sqlAlterColumnComment(builder, to).newStatement();
        }
        if (!AbstractDatabaseDialect.isSameAutoInc(from, to)) {
            this.sqlAddColumnAutoIncrement(builder, to).newStatement();
        }
        if (builder.getStatements().size() == before && forceOutput) {
            support.sqlAlterColumnName(builder, from, to.getName()).newStatement();
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlAlterColumnDefinition"));
        }
        return ddlBuilder;
    }

    protected static boolean isSameAutoInc(@NotNull DasColumn from, @NotNull DasColumn to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/dialects/AbstractDatabaseDialect", "isSameAutoInc"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/dialects/AbstractDatabaseDialect", "isSameAutoInc"));
        }
        Set fAttr = ContainerUtil.notNullize(from.getTable() == null ? null : from.getTable().getColumnAttrs(from));
        Set tAttr = ContainerUtil.notNullize(to.getTable() == null ? null : to.getTable().getColumnAttrs(to));
        return fAttr.contains(DasColumn.Attribute.AUTO_GENERATED) == tAttr.contains(DasColumn.Attribute.AUTO_GENERATED);
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateTable(@NotNull DdlBuilder builder, @NotNull List<? extends DasTable> tables, boolean constraintsAtEnd, @Nullable Set<? extends DasForeignKey> ignoreFks) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlCreateTable"));
        }
        if (tables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tables", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlCreateTable"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getCreateTableSQL(builder, tables, constraintsAtEnd, this, ignoreFks);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlCreateTable"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateSchema(@NotNull DdlBuilder builder, @NotNull DasNamespace schema) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlCreateSchema"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlCreateSchema"));
        }
        if (!this.supportsCreateSchema()) {
            throw new UnsupportedOperationException("Create schema is not supported");
        }
        DdlBuilder ddlBuilder = builder.keywords("CREATE", "SCHEMA").space().qualifiedRef((DasObject)schema);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlCreateSchema"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateDatabase(@NotNull DdlBuilder builder, @NotNull DasNamespace database) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlCreateDatabase"));
        }
        if (database == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "database", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlCreateDatabase"));
        }
        if (!this.supportsCreateDatabase()) {
            throw new UnsupportedOperationException("Create database is not supported");
        }
        DdlBuilder ddlBuilder = builder.keywords("CREATE", "DATABASE").space().qualifiedRef((DasObject)database);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlCreateDatabase"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameSchema(@NotNull DdlBuilder builder, @NotNull DasNamespace schema, @NotNull String name) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlRenameSchema"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlRenameSchema"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlRenameSchema"));
        }
        if (!this.supportsRenameSchema()) {
            throw new UnsupportedOperationException("Rename schema is not supported");
        }
        DdlBuilder ddlBuilder = builder.keywords("ALTER", "SCHEMA").space().qualifiedRef((DasObject)schema).space().keywords("RENAME", "TO").space().identifier((DasObject)schema, name);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlRenameSchema"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameDatabase(@NotNull DdlBuilder builder, @NotNull DasNamespace database, @NotNull String name) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlRenameDatabase"));
        }
        if (database == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "database", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlRenameDatabase"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlRenameDatabase"));
        }
        if (!this.supportsRenameDatabase()) {
            throw new UnsupportedOperationException("Rename database is not supported");
        }
        DdlBuilder ddlBuilder = builder.keywords("ALTER", "DATABASE").space().qualifiedRef((DasObject)database).space().keywords("RENAME", "TO").space().identifier((DasObject)database, name);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlRenameDatabase"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineForeignKey(@NotNull DdlBuilder builder, DasForeignKey info, boolean matchFull) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDefineForeignKey"));
        }
        DdlBuilder ddlBuilder = DialectUtils.foreignKeyTail(builder, info, null, false, null, null);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDefineForeignKey"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineColumn(@NotNull DdlBuilder builder, DasColumn column, boolean singlePk) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDefineColumn"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnDefinitionSQL(builder, column, singlePk);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDefineColumn"));
        }
        return ddlBuilder;
    }

    public boolean supportsDropProcedure() {
        return true;
    }

    public boolean supportsDropTrigger() {
        return true;
    }

    public boolean supportsDropRule() {
        return false;
    }

    public boolean supportsDropPackage() {
        return false;
    }

    public boolean supportsDropCluster() {
        return false;
    }

    public boolean supportsDropSynonym() {
        return false;
    }

    public boolean supportsSystemViewDefinition() {
        return this.supportsViewDefinition();
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropProcedure(@NotNull DdlBuilder builder, @NotNull DasRoutine procedure) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropProcedure"));
        }
        if (procedure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "procedure", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropProcedure"));
        }
        DdlBuilder ddlBuilder = DialectUtils.sqlDropProcedure(builder, procedure, false);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropProcedure"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropTrigger(@NotNull DdlBuilder builder, @NotNull DasTrigger trigger2) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropTrigger"));
        }
        if (trigger2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trigger", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropTrigger"));
        }
        builder.keywords("DROP", "TRIGGER").space().qualifiedRef((DasObject)trigger2);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropTrigger"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropRule(@NotNull DdlBuilder builder, @NotNull DasTableChild rule) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropRule"));
        }
        if (rule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rule", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropRule"));
        }
        throw new UnsupportedOperationException("drop rule is not supported");
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSchema(@NotNull DdlBuilder builder, @NotNull DasNamespace namespace) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropSchema"));
        }
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropSchema"));
        }
        if (!this.supportsDropSchema()) {
            throw new UnsupportedOperationException("drop schema is not supported");
        }
        DdlBuilder ddlBuilder = builder.keywords("DROP", "SCHEMA").space().qualifiedRef((DasObject)namespace);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropSchema"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropDatabase(@NotNull DdlBuilder builder, @NotNull DasNamespace namespace) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropDatabase"));
        }
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropDatabase"));
        }
        if (!this.supportsDropDatabase()) {
            throw new UnsupportedOperationException("drop database is not supported");
        }
        DdlBuilder ddlBuilder = builder.keywords("DROP", "DATABASE").space().qualifiedRef((DasObject)namespace);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropDatabase"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropPackage(@NotNull DdlBuilder builder, @NotNull DasSchemaChild pkg) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropPackage"));
        }
        if (pkg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkg", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropPackage"));
        }
        throw new UnsupportedOperationException("drop package is not supported");
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropCluster(@NotNull DdlBuilder builder, @NotNull DasCluster cluster) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropCluster"));
        }
        if (cluster == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cluster", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropCluster"));
        }
        throw new UnsupportedOperationException("drop cluster is not supported");
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSynonym(@NotNull DdlBuilder builder, @NotNull DasSynonym synonym) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropSynonym"));
        }
        if (synonym == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "synonym", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropSynonym"));
        }
        if (!this.supportsDropSynonym()) {
            throw new UnsupportedOperationException("drop synonym is not supported");
        }
        DdlBuilder ddlBuilder = builder.keywords("DROP", "SYNONYM").space().qualifiedRef((DasObject)synonym);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropSynonym"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropMaterializedView(@NotNull DdlBuilder builder, @NotNull DasTable view2) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropMaterializedView"));
        }
        if (view2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropMaterializedView"));
        }
        if (!this.supportsDropMaterializedView()) {
            throw new UnsupportedOperationException("drop materialized view is not supported");
        }
        DdlBuilder ddlBuilder = builder.keywords("DROP", "MATERIALIZED", "VIEW").space().qualifiedRef((DasObject)view2);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropMaterializedView"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropOperator(@NotNull DdlBuilder builder, @NotNull DasOperator operator) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropOperator"));
        }
        if (operator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operator", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropOperator"));
        }
        throw new UnsupportedOperationException("Unable to drop operator");
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropType(@NotNull DdlBuilder builder, @NotNull DasUserDefinedType type) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropType"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropType"));
        }
        if (!this.supportsDropType()) {
            throw new UnsupportedOperationException("Unable to drop type");
        }
        DdlBuilder ddlBuilder = builder.keywords("DROP", "TYPE").space().qualifiedRef((DasObject)type);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropType"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropForeignKey(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasForeignKey fk, @NotNull String fkName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropForeignKey"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropForeignKey"));
        }
        if (fkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fkName", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropForeignKey"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropForeignKeySQL(builder, fk, fkName, table);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropForeignKey"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlInsertInto(@NotNull DdlBuilder builder, @NotNull DasTable table, @NotNull List<String> columns, @NotNull List<String> values) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlInsertInto"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlInsertInto"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlInsertInto"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlInsertInto"));
        }
        builder.keyword("INSERT").space().keyword("INTO").space().qualifiedRef((DasObject)table);
        if (!columns.isEmpty()) {
            builder.space().symbol("(");
            DialectUtils.appendStringList(builder, columns);
            builder.symbol(")");
        }
        if (values.isEmpty() && this.supportsInsertDefaultValues()) {
            builder.space().keyword("DEFAULT").space().keyword("VALUES");
        } else {
            builder.space().keyword("VALUES").space().symbol("(");
            DialectUtils.appendPlainList(builder, values);
            builder.symbol(")");
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlInsertInto"));
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsInsertDefaultValues() {
        return false;
    }

    @Override
    public boolean supportsInsertDefaultIntoAutoVal() {
        return false;
    }

    protected boolean isCommentDroppedByNull() {
        return false;
    }

    @Override
    public DdlBuilder sqlAlterObjectComment(@NotNull DdlBuilder builder, @NotNull DasObject object) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlAlterObjectComment"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlAlterObjectComment"));
        }
        String type = null;
        if (object.getKind() == ObjectKind.COLUMN) {
            type = "COLUMN";
        } else if (object.getKind() == ObjectKind.TABLE) {
            type = "TABLE";
        }
        if (type != null) {
            DialectUtils.getObjectCommentAlterSQL(builder, type, object, this.isCommentDroppedByNull(), DbSqlUtil.getSqlDialect(this));
        }
        return builder;
    }

    @NotNull
    public String getLengthFunction() {
        if ("length" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "getLengthFunction"));
        }
        return "length";
    }

    public boolean supportsCreateDatabase() {
        return false;
    }

    public boolean supportsRenameDatabase() {
        return this.supportsCreateDatabase();
    }

    public boolean supportsCreateSchema() {
        return true;
    }

    public boolean supportsRenameSchema() {
        return this.supportsCreateSchema();
    }

    @NotNull
    public String getMaxFunction() {
        if ("max" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "getMaxFunction"));
        }
        return "max";
    }

    @NotNull
    public String getNullColumnString() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "getNullColumnString"));
        }
        return "";
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropTable(@NotNull DdlBuilder builder, @NotNull DasTable table, boolean cascadeConstraints, boolean isMaterializedView, @NotNull DasModel model) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropTable"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropTable"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropTable"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getTableDropSQL(builder, table, true, cascadeConstraints, false, "CASCADE", false);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropTable"));
        }
        return ddlBuilder;
    }

    @NotNull
    public String getTypeName(@NotNull DataType dataType) {
        String typeName;
        if (dataType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/database/dialects/AbstractDatabaseDialect", "getTypeName"));
        }
        if (dataType.jdbcType == 0) {
            String string = dataType.getSpecification();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "getTypeName"));
            }
            return string;
        }
        int jdbcType = dataType.jdbcType;
        int length = dataType.getLength();
        int precision = dataType.getPrecision();
        int scale = dataType.getScale();
        if (jdbcType == 1111) {
            jdbcType = this.getJavaTypeForNativeType(dataType.getSpecification());
        }
        String string = (typeName = this.myTypeHelper.getTypeName(jdbcType, length, precision, scale)) != null ? typeName : JdbcUtil.getJdbcTypeName((DataType)dataType);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "getTypeName"));
        }
        return string;
    }

    @NotNull
    public TypeHelper getTypeHelper() {
        TypeHelper typeHelper = this.myTypeHelper;
        if (typeHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "getTypeHelper"));
        }
        return typeHelper;
    }

    @NotNull
    public String getTypeWithSubstitution(@NotNull String name, int length, int precision, int scale) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dialects/AbstractDatabaseDialect", "getTypeWithSubstitution"));
        }
        String string = this.myTypeHelper.getTypeWithSubstitution(name, length, precision, scale);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "getTypeWithSubstitution"));
        }
        return string;
    }

    public int getJavaTypeForNativeType(@NotNull String nativeColumnTypeName) {
        if (nativeColumnTypeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeColumnTypeName", "com/intellij/database/dialects/AbstractDatabaseDialect", "getJavaTypeForNativeType"));
        }
        return this.myTypeHelper.findJdbcType(nativeColumnTypeName);
    }

    public boolean supportsTableDefinition() {
        return false;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlTableDefinition(@NotNull DasObject element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlTableDefinition"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.table.definition", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull Connection connection) throws Exception {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/AbstractDatabaseDialect", "tryToLoadTableDefinition"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/AbstractDatabaseDialect", "tryToLoadTableDefinition"));
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "tryToLoadTableDefinition"));
        }
        return "";
    }

    public boolean supportsTableInfo() {
        return false;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull Connection connection) throws Exception {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/AbstractDatabaseDialect", "tryToLoadTableInfo"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/AbstractDatabaseDialect", "tryToLoadTableInfo"));
        }
        Map<String, Object> map = Collections.emptyMap();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "tryToLoadTableInfo"));
        }
        return map;
    }

    @Override
    public boolean supportsSearchPath() {
        return false;
    }

    @Override
    public ObjectKind getSearchPathObjectKind() {
        return ObjectKind.SCHEMA;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DatabaseSystem system, @NotNull Connection connection) throws SQLException {
        if (system == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "system", "com/intellij/database/dialects/AbstractDatabaseDialect", "tryToLoadSearchPath"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/AbstractDatabaseDialect", "tryToLoadSearchPath"));
        }
        return null;
    }

    @Override
    public String sqlSetSearchPath(@NotNull DatabaseSystem system, @NotNull SearchPath path) {
        if (system == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "system", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlSetSearchPath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlSetSearchPath"));
        }
        return null;
    }

    public boolean supportsCreateTable() {
        return true;
    }

    public boolean supportsDropMaterializedView() {
        return false;
    }

    public boolean supportsDropOperator() {
        return false;
    }

    public boolean supportsDropType() {
        return false;
    }

    public boolean supportsDropSchema() {
        return false;
    }

    public boolean supportsDropDatabase() {
        return this.supportsCreateDatabase();
    }

    public boolean supportsDropColumn() {
        return true;
    }

    public boolean supportsInsertInto() {
        return true;
    }

    public boolean supportsSchemasInTableDefinition() {
        return true;
    }

    public char closeQuote() {
        return '\"';
    }

    public char openQuote() {
        return '\"';
    }

    @Nullable
    public String getNameForKind(@NotNull ObjectKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/dialects/AbstractDatabaseDialect", "getNameForKind"));
        }
        return kind.name();
    }

    public boolean supportsSubSecondTimestamps() {
        return true;
    }

    public boolean supportsAddPrimaryKey() {
        return true;
    }

    public boolean supportsRenameRoutine() {
        return true;
    }

    public boolean supportsModifyColumn() {
        return this.supportsRenameColumn();
    }

    public boolean supportsDropPrimaryKey() {
        return true;
    }

    public String getBinaryLiteralString(@NotNull byte[] binaryData) {
        if (binaryData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binaryData", "com/intellij/database/dialects/AbstractDatabaseDialect", "getBinaryLiteralString"));
        }
        return "'" + DialectUtils.toHexString(binaryData) + "'";
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropPrimaryKey"));
        }
        if (pk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pk", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropPrimaryKey"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropPrimaryKeySQL(builder, pk, false, false);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDropPrimaryKey"));
        }
        return ddlBuilder;
    }

    public boolean supportsDropForeignKey() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefinePrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey primaryKey) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDefinePrimaryKey"));
        }
        if (primaryKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryKey", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDefinePrimaryKey"));
        }
        builder.keywords("PRIMARY", "KEY").space().symbol("(");
        boolean first = true;
        MultiRef.It it = primaryKey.getColumnsRef().iterate();
        while (it.hasNext()) {
            String pk = (String)it.next();
            if (first) {
                first = false;
            } else {
                builder.symbol(",").space();
            }
            builder.constraintRef((DasObject)it.resolve(), pk);
        }
        builder.symbol(")");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDefinePrimaryKey"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public String tryToLoadProcedureDefinition(@NotNull DasRoutine proc, @NotNull Connection connection) throws Exception {
        if (proc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proc", "com/intellij/database/dialects/AbstractDatabaseDialect", "tryToLoadProcedureDefinition"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/AbstractDatabaseDialect", "tryToLoadProcedureDefinition"));
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "tryToLoadProcedureDefinition"));
        }
        return "";
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlPackageBodyDefinition(@NotNull DasObject element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlPackageBodyDefinition"));
        }
        throw new UnsupportedOperationException("Package body definition is not supported");
    }

    public boolean supportsPackageDefinition() {
        return false;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlPackageDefinition(@NotNull DasObject element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlPackageDefinition"));
        }
        throw new UnsupportedOperationException("Package definition is not supported");
    }

    public boolean supportsSequenceDefinition() {
        return false;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlSequenceDefinition(@NotNull DasObject element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlSequenceDefinition"));
        }
        throw new UnsupportedOperationException("Sequence definition is not supported");
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlSynonymDefinition(@NotNull DasObject element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlSynonymDefinition"));
        }
        throw new UnsupportedOperationException("Synonym definition is not supported");
    }

    @Override
    @NotNull
    public String tryToLoadSynonymDefinition(DasTable tableElement, Connection connection) throws Exception {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "tryToLoadSynonymDefinition"));
        }
        return "";
    }

    @Override
    @NotNull
    public DdlBuilder sqlPostExplainPlan(@NotNull DdlBuilder builder, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlPostExplainPlan"));
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlPostExplainPlan"));
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsInlineAddPrimaryKey() {
        return false;
    }

    public boolean supportsSynonymDefinition() {
        return false;
    }

    public boolean supportsQualifiedAsteriskInCalls() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineProcedure(@NotNull DdlBuilder builder, @NotNull DasRoutine procedure) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDefineProcedure"));
        }
        if (procedure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "procedure", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDefineProcedure"));
        }
        String type = procedure.getRoutineKind().name();
        String pkgName = procedure.getPackageName();
        if (pkgName == null) {
            builder.keyword("create").space();
        }
        builder.keyword(type).space().qualifiedRef((DasObject)procedure);
        this.sqlDefinePrototype(builder, procedure, true, true);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDefineProcedure"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefinePrototype(@NotNull DdlBuilder builder, @NotNull DasRoutine routine2, boolean longMode, boolean withReturn) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDefinePrototype"));
        }
        if (routine2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDefinePrototype"));
        }
        JBIterable parameters = DasUtil.getParameters((DasRoutine)routine2);
        DasArgument returnArg = routine2.getReturnArgument();
        int len = Iterables.size((Iterable)parameters);
        if (len == 0) {
            DdlBuilder ddlBuilder = builder.symbol("(").symbol(")");
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDefinePrototype"));
            }
            return ddlBuilder;
        }
        builder.symbol("(");
        boolean first = true;
        for (DasArgument parameter : parameters) {
            if (first) {
                first = false;
            } else {
                builder.symbol(",").space();
            }
            DasArgument.Direction parameterType = parameter.getArgumentDirection();
            if (longMode) {
                if (StringUtil.isNotEmpty((String)parameter.getName())) {
                    if (builder.getDialect().getFamilyId().isTransactSql()) {
                        builder.plain(parameter.getName()).space();
                    } else {
                        builder.identifier((DasObject)parameter, parameter.getName()).space();
                    }
                }
            } else if (parameterType != DasArgument.Direction.IN) {
                builder.keyword(parameterType.name()).space();
            }
            builder.type((DasTypedObject)parameter);
        }
        builder.symbol(")");
        if (returnArg != null && withReturn) {
            if (longMode) {
                builder.space().keyword("returns").space();
            } else {
                builder.plain(": ");
            }
            builder.type((DasTypedObject)returnArg);
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "sqlDefinePrototype"));
        }
        return ddlBuilder;
    }

    public boolean supportsAutoIncrement() {
        return false;
    }

    @Override
    public boolean supportsLoadDatabaseList() {
        return false;
    }

    @Override
    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull Connection connection) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/AbstractDatabaseDialect", "tryToLoadDatabaseList"));
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "tryToLoadDatabaseList"));
        }
        return list;
    }

    @NotNull
    public static DdlBuilder multiInsertStatement(@NotNull DdlBuilder builder, DasTable table, @NotNull List<String> columns, @NotNull DatabaseDialectEx myDialect, @NotNull List<List<String>> params2) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "multiInsertStatement"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dialects/AbstractDatabaseDialect", "multiInsertStatement"));
        }
        if (myDialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myDialect", "com/intellij/database/dialects/AbstractDatabaseDialect", "multiInsertStatement"));
        }
        if (params2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/database/dialects/AbstractDatabaseDialect", "multiInsertStatement"));
        }
        builder.keyword("INSERT").space().keyword("INTO").space().qualifiedRef((DasObject)table);
        boolean empty = columns.isEmpty();
        if (empty) {
            if (myDialect.supportsInsertDefaultValues()) {
                builder.space().keyword("DEFAULT").space().keyword("VALUES");
                DdlBuilder ddlBuilder = builder;
                if (ddlBuilder == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "multiInsertStatement"));
                }
                return ddlBuilder;
            }
            throw new IllegalArgumentException("Can't insert values without columns");
        }
        builder.space().symbol("(");
        DialectUtils.appendStringList(builder, columns);
        builder.symbol(")");
        builder.space().keyword("VALUES").space();
        int linesCount = params2.size();
        for (int i2 = 0; i2 < linesCount; ++i2) {
            builder.symbol("(");
            DialectUtils.appendPlainList(builder, (Iterable<String>)params2.get(i2));
            builder.symbol(")");
            if (i2 >= linesCount - 1) continue;
            builder.literal(",");
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "multiInsertStatement"));
        }
        return ddlBuilder;
    }

    @Override
    public boolean hasRowId(@Nullable DatabaseSystem system) {
        return false;
    }

    @NotNull
    protected LimitPlace getPlaceForLimit(@Nullable DatabaseSystem system) {
        LimitPlace limitPlace = LimitPlace.END;
        if (limitPlace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "getPlaceForLimit"));
        }
        return limitPlace;
    }

    @NotNull
    protected DdlBuilder appendLimit(@NotNull DdlBuilder builder, @Nullable DatabaseSystem system, int rows) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "appendLimit"));
        }
        DdlBuilder ddlBuilder = builder.space().keyword("LIMIT").space().literal(String.valueOf(rows));
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "appendLimit"));
        }
        return ddlBuilder;
    }

    @NotNull
    protected DdlBuilder appendRowId(@NotNull DdlBuilder builder, @Nullable DatabaseSystem system) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "appendRowId"));
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "appendRowId"));
        }
        return ddlBuilder;
    }

    @NotNull
    protected static DdlBuilder top(@NotNull DdlBuilder builder, @NotNull String topWord, int rows) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "top"));
        }
        if (topWord == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topWord", "com/intellij/database/dialects/AbstractDatabaseDialect", "top"));
        }
        DdlBuilder ddlBuilder = builder.keyword(topWord).space().literal(String.valueOf(rows)).space();
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "top"));
        }
        return ddlBuilder;
    }

    @NotNull
    protected static DdlBuilder fetchFirst(@NotNull DdlBuilder builder, int rows) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "fetchFirst"));
        }
        DdlBuilder ddlBuilder = builder.space().keywords("FETCH", "FIRST").space().literal(String.valueOf(rows)).space().keywords("ROWS", "ONLY");
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "fetchFirst"));
        }
        return ddlBuilder;
    }

    @NotNull
    protected static DdlBuilder rowNumLimit(@NotNull DdlBuilder builder, int rows) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect", "rowNumLimit"));
        }
        String statement = builder.getStatement();
        builder.clear();
        builder.keyword("SELECT").space().symbol("*").space().keyword("FROM").space().symbol("(").plain(statement).symbol(")").space().keyword("WHERE").space().keyword("ROWNUM").space().symbol("<=").space().literal(String.valueOf(rows));
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/AbstractDatabaseDialect", "rowNumLimit"));
        }
        return ddlBuilder;
    }

    @Override
    @Nullable
    public DatabaseDialectEx.VersionParser getVersionParser() {
        return null;
    }

    protected static enum LimitPlace {
        BEGIN,
        END;


        DdlBuilder appendLimit(@NotNull DdlBuilder builder, @NotNull AbstractDatabaseDialect dialect, @NotNull LimitPlace place, @Nullable DatabaseSystem system, int rows) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/AbstractDatabaseDialect$LimitPlace", "appendLimit"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dialects/AbstractDatabaseDialect$LimitPlace", "appendLimit"));
            }
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/database/dialects/AbstractDatabaseDialect$LimitPlace", "appendLimit"));
            }
            return place == this ? dialect.appendLimit(builder, system, rows) : builder;
        }
    }

    protected static interface SplitAlterColumnSupport {
        @NotNull
        public DdlBuilder sqlAlterColumnComment(@NotNull DdlBuilder var1, @NotNull DasColumn var2);

        @NotNull
        public DdlBuilder sqlAlterColumnNullable(@NotNull DdlBuilder var1, @NotNull DasColumn var2);

        @NotNull
        public DdlBuilder sqlAlterColumnName(@NotNull DdlBuilder var1, @NotNull DasColumn var2, @NotNull String var3);

        @NotNull
        public DdlBuilder sqlAlterColumnType(@NotNull DdlBuilder var1, @NotNull DasColumn var2, @NotNull DasColumn var3);

        @NotNull
        public DdlBuilder sqlAlterColumnDefault(@NotNull DdlBuilder var1, @NotNull DasColumn var2);
    }
}

