/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.diff.TableDiffViewer;
import com.intellij.diff.DiffContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.contents.DiffContentBase;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableDiffTool
implements FrameDiffTool {
    public static final TableDiffTool INSTANCE = new TableDiffTool();

    @NotNull
    public String getName() {
        if ("Table Diff" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffTool", "getName"));
        }
        return "Table Diff";
    }

    public boolean canShow(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/diff/TableDiffTool", "canShow"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/diff/TableDiffTool", "canShow"));
        }
        return TableDiffViewer.canShowRequest(context, request);
    }

    @NotNull
    public FrameDiffTool.DiffViewer createComponent(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/diff/TableDiffTool", "createComponent"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/diff/TableDiffTool", "createComponent"));
        }
        TableDiffViewer tableDiffViewer = new TableDiffViewer(context, request);
        if (tableDiffViewer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffTool", "createComponent"));
        }
        return tableDiffViewer;
    }

    public static class TableDiffContent
    extends DiffContentBase {
        private final MyCountedRef myRef;

        public TableDiffContent(@NotNull GridDataHookUpManager.HookUpHandle handle, @NotNull Project project) {
            if (handle == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handle", "com/intellij/database/diff/TableDiffTool$TableDiffContent", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/diff/TableDiffTool$TableDiffContent", "<init>"));
            }
            this.myRef = new MyCountedRef(handle, project);
        }

        @Nullable
        public GridDataHookUp<DataConsumer.Row, DataConsumer.Column> getHookUp() {
            return this.myRef.getLocked();
        }

        @Nullable
        public FileType getContentType() {
            return null;
        }

        public void onAssigned(boolean isAssigned) {
            if (isAssigned) {
                this.myRef.acquire();
            } else {
                this.myRef.release();
            }
        }

        private static class MyCountedRef
        implements Disposable {
            private int myCounter;
            private GridDataHookUp<DataConsumer.Row, DataConsumer.Column> myLocked;
            private final GridDataHookUpManager.HookUpHandle myHandle;
            private final Project myProject;

            public MyCountedRef(@NotNull GridDataHookUpManager.HookUpHandle handle, @NotNull Project project) {
                if (handle == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handle", "com/intellij/database/diff/TableDiffTool$TableDiffContent$MyCountedRef", "<init>"));
                }
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/diff/TableDiffTool$TableDiffContent$MyCountedRef", "<init>"));
                }
                this.myCounter = 0;
                this.myProject = project;
                this.myHandle = handle;
            }

            public void acquire() {
                if (this.myCounter == 0) {
                    GridDataHookUpManager manager = GridDataHookUpManager.getInstance(this.myProject);
                    this.myLocked = manager.acquire(this.myHandle, this);
                }
                ++this.myCounter;
            }

            public void release() {
                --this.myCounter;
                if (this.myCounter == 0) {
                    Disposer.dispose((Disposable)this);
                }
            }

            public void dispose() {
                this.myLocked = null;
            }

            @Nullable
            public GridDataHookUp<DataConsumer.Row, DataConsumer.Column> getLocked() {
                return this.myLocked;
            }
        }
    }
}

