/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.postgres.PostgresModDatabase;
import com.intellij.database.model.postgres.PostgresModDefType;
import com.intellij.database.model.postgres.PostgresModMatView;
import com.intellij.database.model.postgres.PostgresModOperator;
import com.intellij.database.model.postgres.PostgresModRoutine;
import com.intellij.database.model.postgres.PostgresModSequence;
import com.intellij.database.model.postgres.PostgresModTable;
import com.intellij.database.model.postgres.PostgresModView;
import com.intellij.database.model.postgres.PostgresSchema;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PostgresModSchema
extends PostgresSchema,
BasicModSchema,
BasicModIdentifiedElement,
BasicModNamedElement {
    @Override
    @NotNull
    public PostgresModDatabase getDatabase();

    @Override
    @NotNull
    default public PostgresModDatabase getDbParent() {
        PostgresModDatabase postgresModDatabase = this.getDatabase();
        if (postgresModDatabase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresModSchema", "getDbParent"));
        }
        return postgresModDatabase;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModSchema> getParentFamily();

    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModSequence> getSequences();

    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModDefType> getDefTypes();

    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModTable> getTables();

    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModView> getViews();

    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModMatView> getMatViews();

    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModRoutine> getRoutines();

    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModOperator> getOperators();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getSequences(), this.getDefTypes(), this.getTables(), this.getViews(), this.getMatViews(), this.getRoutines(), this.getOperators());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresModSchema", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append((Iterable)this.getSequences()).append((Iterable)this.getDefTypes()).append((Iterable)this.getTables()).append((Iterable)this.getViews()).append((Iterable)this.getMatViews()).append((Iterable)this.getRoutines()).append((Iterable)this.getOperators());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresModSchema", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setObjectId(long var1);

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setIntrospectionTimestamp(@Nullable Date var1);

    public void setIntrospectionStateNumber(long var1);

    @Override
    public void setCurrent(boolean var1);

    @Override
    public void setVisible(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/postgres/PostgresModSchema", "importProperties"));
        }
        String objectId = properties.get("ObjectId");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String introspectionTimestamp = properties.get("IntrospectionTimestamp");
        String introspectionStateNumber = properties.get("IntrospectionStateNumber");
        String current = properties.get("Current");
        String visible = properties.get("Visible");
        if (objectId != null) {
            this.setObjectId(PropertyConverter.importLong(objectId));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (introspectionTimestamp != null) {
            this.setIntrospectionTimestamp(PropertyConverter.importDate(introspectionTimestamp));
        }
        if (introspectionStateNumber != null) {
            this.setIntrospectionStateNumber(PropertyConverter.importLong(introspectionStateNumber));
        }
        if (current != null) {
            this.setCurrent(PropertyConverter.importBoolean(current));
        }
        if (visible != null) {
            this.setVisible(PropertyConverter.importBoolean(visible));
        }
    }
}

