/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties;

import org.jetbrains.annotations.NotNull;

public enum PostgresOperatorKind {
    UNKNOWN('\u0000'),
    BINARY('b'),
    PREFIX('l'),
    POSTFIX('r');

    public final char code;

    private PostgresOperatorKind(char code) {
        this.code = code;
    }

    @NotNull
    public static PostgresOperatorKind of(char code) {
        switch (code) {
            case 'B': 
            case 'b': {
                PostgresOperatorKind postgresOperatorKind = BINARY;
                if (postgresOperatorKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/properties/PostgresOperatorKind", "of"));
                }
                return postgresOperatorKind;
            }
            case 'L': 
            case 'l': {
                PostgresOperatorKind postgresOperatorKind = PREFIX;
                if (postgresOperatorKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/properties/PostgresOperatorKind", "of"));
                }
                return postgresOperatorKind;
            }
            case 'R': 
            case 'r': {
                PostgresOperatorKind postgresOperatorKind = POSTFIX;
                if (postgresOperatorKind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/properties/PostgresOperatorKind", "of"));
                }
                return postgresOperatorKind;
            }
        }
        PostgresOperatorKind postgresOperatorKind = UNKNOWN;
        if (postgresOperatorKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/properties/PostgresOperatorKind", "of"));
        }
        return postgresOperatorKind;
    }
}

