/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridLoader;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.run.actions.GridAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.util.PlatformIcons;
import icons.DatabaseIcons;
import javax.swing.Icon;

public abstract class PageAction
extends DumbAwareAction
implements GridAction {
    public PageAction(Icon icon) {
        super(null, null, icon);
    }

    protected abstract boolean isEnabled(GridPagingModel<DataConsumer.Row, DataConsumer.Column> var1);

    protected abstract void actionPerformed(GridRequestSource<DataConsumer.Row, DataConsumer.Column> var1, GridLoader<DataConsumer.Row, DataConsumer.Column> var2);

    public void update(AnActionEvent e) {
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        e.getPresentation().setEnabled(dataGrid != null && dataGrid.isReady() && this.isEnabled(dataGrid.getDataHookup().getPageModel()));
    }

    public void actionPerformed(AnActionEvent e) {
        GridMutator mutator;
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        if (dataGrid == null) {
            return;
        }
        if (!dataGrid.stopEditing()) {
            dataGrid.cancelEditing();
        }
        if ((mutator = dataGrid.getDataHookup().getMutator()) == null || !mutator.hasPendingChanges() || DataGridUtil.showIgnoreUnsubmittedChangesYesNoDialog(dataGrid)) {
            this.actionPerformed(GridRequestSource.create(dataGrid, null), dataGrid.getDataHookup().getLoader());
        }
    }

    public static class Previous
    extends PageAction {
        public Previous() {
            super(DatabaseIcons.Play_back);
        }

        @Override
        protected boolean isEnabled(GridPagingModel<DataConsumer.Row, DataConsumer.Column> pageModel) {
            return !pageModel.isFirstPage();
        }

        @Override
        protected void actionPerformed(GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, GridLoader<DataConsumer.Row, DataConsumer.Column> loader) {
            loader.loadPreviousPage(source);
        }
    }

    public static class Next
    extends PageAction {
        public Next() {
            super(DatabaseIcons.Play_forward);
        }

        @Override
        protected boolean isEnabled(GridPagingModel<DataConsumer.Row, DataConsumer.Column> pageModel) {
            return !pageModel.isLastPage();
        }

        @Override
        protected void actionPerformed(GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, GridLoader<DataConsumer.Row, DataConsumer.Column> loader) {
            loader.loadNextPage(source);
        }
    }

    public static class Last
    extends PageAction {
        public Last() {
            super(DatabaseIcons.Play_last);
        }

        @Override
        protected boolean isEnabled(GridPagingModel<DataConsumer.Row, DataConsumer.Column> pageModel) {
            return !pageModel.isLastPage();
        }

        @Override
        protected void actionPerformed(GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, GridLoader<DataConsumer.Row, DataConsumer.Column> loader) {
            loader.loadLastPage(source);
        }
    }

    public static class First
    extends PageAction {
        public First() {
            super(DatabaseIcons.Play_first);
        }

        @Override
        protected boolean isEnabled(GridPagingModel<DataConsumer.Row, DataConsumer.Column> pageModel) {
            return !pageModel.isFirstPage();
        }

        @Override
        protected void actionPerformed(GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, GridLoader<DataConsumer.Row, DataConsumer.Column> loader) {
            loader.loadFirstPage(source);
        }
    }

    public static class Reload
    extends PageAction {
        public Reload() {
            super(PlatformIcons.SYNCHRONIZE_ICON);
        }

        @Override
        protected boolean isEnabled(GridPagingModel<DataConsumer.Row, DataConsumer.Column> pageModel) {
            return true;
        }

        @Override
        protected void actionPerformed(GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, GridLoader<DataConsumer.Row, DataConsumer.Column> loader) {
            loader.reloadCurrentPage(source);
        }
    }
}

