/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.model.DasColumn;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class SetValueAction
extends AnAction
implements DumbAware,
GridAction {
    private final ReservedCellValue myValue;

    protected SetValueAction(ReservedCellValue value) {
        this.myValue = value;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/SetValueAction", "update"));
        }
        DataGrid grid = DataGridUtil.getDataGrid(e.getDataContext());
        if (grid == null || !grid.isEditable() || !grid.isReady()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        SelectionModel selectionModel = grid.getSelectionModel();
        e.getPresentation().setEnabledAndVisible(selectionModel.getSelectedRowCount() >= 1 && selectionModel.getSelectedColumnCount() >= 1 && this.areSelectedColumnsAssignable(grid));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/SetValueAction", "actionPerformed"));
        }
        DataGrid grid = DataGridUtil.getDataGrid(e.getDataContext());
        if (grid != null) {
            grid.cancelEditing();
            grid.setCells(grid.getSelectionModel().getSelectedRows(), grid.getSelectionModel().getSelectedColumns(), (Object)this.myValue);
        }
    }

    protected abstract boolean canSetValue(@NotNull DasColumn var1);

    public ReservedCellValue getValue() {
        return this.myValue;
    }

    private boolean areSelectedColumnsAssignable(@NotNull DataGrid grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/actions/SetValueAction", "areSelectedColumnsAssignable"));
        }
        List selectedColumns = grid.getDataModel(DataAccessType.DATABASE_DATA).getColumns(grid.getSelectionModel().getSelectedColumns());
        Condition notAssignable = column -> {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/actions/SetValueAction", "lambda$areSelectedColumnsAssignable$0"));
            }
            DasColumn columnInfo = DataGridUtil.getDatabaseColumn(grid, column);
            return columnInfo == null || !this.canSetValue(columnInfo);
        };
        return JBIterable.from(selectedColumns).filter(notAssignable).isEmpty();
    }

    public static class SetNullAction
    extends SetValueAction {
        public SetNullAction() {
            super(ReservedCellValue.NULL);
        }

        @Override
        protected boolean canSetValue(@NotNull DasColumn columnInfo) {
            if (columnInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnInfo", "com/intellij/database/run/actions/SetValueAction$SetNullAction", "canSetValue"));
            }
            return !columnInfo.isNotNull();
        }
    }

    public static class SetDefaultAction
    extends SetValueAction {
        public SetDefaultAction() {
            super(ReservedCellValue.DEFAULT);
        }

        @Override
        protected boolean canSetValue(@NotNull DasColumn columnInfo) {
            if (columnInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnInfo", "com/intellij/database/run/actions/SetValueAction$SetDefaultAction", "canSetValue"));
            }
            return columnInfo.getDefault() != null;
        }
    }
}

