/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.DocumentDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.openapi.editor.EditorBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum GridEditGuard {
    READ_ONLY_PREVIEW{

        @Override
        boolean rejectEdit(@NotNull DataGrid grid) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/GridEditGuard$1", "rejectEdit"));
            }
            DatabaseGridDataHookUp up = DataGridUtil.getDatabaseHookUp(grid);
            return up instanceof GridDataHookUpManager.ReadOnlyDatabaseGridDataHookUp;
        }

        @Override
        @NotNull
        public String getReasonText(@NotNull DataGrid grid) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/GridEditGuard$1", "getReasonText"));
            }
            String string = this.getReasonInner(grid);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/GridEditGuard$1", "getReasonText"));
            }
            return string;
        }

        @Override
        @NotNull
        String getReasonInner(@NotNull DataGrid grid) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/GridEditGuard$1", "getReasonInner"));
            }
            String string = GridEditGuard.defaultMessage();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/GridEditGuard$1", "getReasonInner"));
            }
            return string;
        }
    }
    ,
    WRONG_KIND{

        @Override
        boolean rejectEdit(@NotNull DataGrid grid) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/GridEditGuard$2", "rejectEdit"));
            }
            DasTable table = DataGridUtil.getDatabaseTable(grid);
            return table != null && table.getKind() != ObjectKind.TABLE;
        }

        @Override
        @NotNull
        public String getReasonText(@NotNull DataGrid grid) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/GridEditGuard$2", "getReasonText"));
            }
            String string = this.getReasonInner(grid);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/GridEditGuard$2", "getReasonText"));
            }
            return string;
        }

        @Override
        @NotNull
        String getReasonInner(@NotNull DataGrid grid) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/GridEditGuard$2", "getReasonInner"));
            }
            DasTable table = DataGridUtil.getDatabaseTable(grid);
            ObjectKind kind = table.getKind();
            String string = String.format("Can't edit %s", kind == ObjectKind.VIEW ? "view" : "materialized view");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/GridEditGuard$2", "getReasonInner"));
            }
            return string;
        }
    }
    ,
    READ_ONLY_CONNECTION{

        @Override
        boolean rejectEdit(@NotNull DataGrid grid) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/GridEditGuard$3", "rejectEdit"));
            }
            DbDataSource system = DataGridUtil.getDatabaseSystem(grid);
            return system != null && !system.isWritable();
        }

        @Override
        @NotNull
        public String getReasonText(@NotNull DataGrid grid) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/GridEditGuard$3", "getReasonText"));
            }
            String string = this.getReasonInner(grid);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/GridEditGuard$3", "getReasonText"));
            }
            return string;
        }

        @Override
        @NotNull
        String getReasonInner(@NotNull DataGrid grid) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/GridEditGuard$3", "getReasonInner"));
            }
            if ("Connection is read-only" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/GridEditGuard$3", "getReasonInner"));
            }
            return "Connection is read-only";
        }
    }
    ,
    MISSING_IDENTIFIER{

        @Override
        boolean rejectEdit(@NotNull DataGrid grid) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/GridEditGuard$4", "rejectEdit"));
            }
            return !DataGridUtil.canBuildWhereClause(grid);
        }

        @Override
        @NotNull
        String getReasonInner(@NotNull DataGrid grid) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/GridEditGuard$4", "getReasonInner"));
            }
            if ("Missing row identifier" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/GridEditGuard$4", "getReasonInner"));
            }
            return "Missing row identifier";
        }
    }
    ,
    UNRESOLVED_TABLE{

        @Override
        boolean rejectEdit(@NotNull DataGrid grid) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/GridEditGuard$5", "rejectEdit"));
            }
            return DataGridUtil.getDatabaseHookUp(grid) != null && DataGridUtil.getDatabaseTable(grid) == null;
        }

        @Override
        @NotNull
        String getReasonInner(@NotNull DataGrid grid) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/GridEditGuard$5", "getReasonInner"));
            }
            if ("Unresolved table reference" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/GridEditGuard$5", "getReasonInner"));
            }
            return "Unresolved table reference";
        }
    }
    ,
    MODAL_IMPORT{

        @Override
        boolean rejectEdit(@NotNull DataGrid grid) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/GridEditGuard$6", "rejectEdit"));
            }
            return DataImporter.isBusy(DataGridUtil.getDatabaseTable(grid));
        }

        @Override
        @NotNull
        String getReasonInner(@NotNull DataGrid grid) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/GridEditGuard$6", "getReasonInner"));
            }
            if ("It is using in data import" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/GridEditGuard$6", "getReasonInner"));
            }
            return "It is using in data import";
        }
    }
    ,
    SEARCH_PATH_MISMATCH{

        @Override
        boolean rejectEdit(@NotNull DataGrid grid) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/GridEditGuard$7", "rejectEdit"));
            }
            return !grid.isReady();
        }

        @Override
        @NotNull
        String getReasonInner(@NotNull DataGrid grid) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/GridEditGuard$7", "getReasonInner"));
            }
            if ("Search path mismatch" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/GridEditGuard$7", "getReasonInner"));
            }
            return "Search path mismatch";
        }
    }
    ,
    READ_ONLY_FILE{

        @Override
        boolean rejectEdit(@NotNull DataGrid grid) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/GridEditGuard$8", "rejectEdit"));
            }
            DocumentDataHookUp up = DataGridUtil.getDocumentDataHookUp(grid);
            return up != null && up.isReadOnly();
        }

        @Override
        @NotNull
        public String getReasonText(@NotNull DataGrid grid) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/GridEditGuard$8", "getReasonText"));
            }
            String string = this.getReasonInner(grid);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/GridEditGuard$8", "getReasonText"));
            }
            return string;
        }

        @Override
        @NotNull
        String getReasonInner(@NotNull DataGrid grid) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/GridEditGuard$8", "getReasonInner"));
            }
            String string = GridEditGuard.defaultMessage();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/GridEditGuard$8", "getReasonInner"));
            }
            return string;
        }
    };


    @NotNull
    public String getReasonText(@NotNull DataGrid grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/GridEditGuard", "getReasonText"));
        }
        String string = String.format("<div style=\"text-align:center\">Table is read-only.<br>%s</div>", this.getReasonInner(grid));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/GridEditGuard", "getReasonText"));
        }
        return string;
    }

    abstract boolean rejectEdit(@NotNull DataGrid var1);

    @NotNull
    abstract String getReasonInner(@NotNull DataGrid var1);

    @Nullable
    public static GridEditGuard get(@NotNull DataGrid grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/GridEditGuard", "get"));
        }
        for (GridEditGuard guard : GridEditGuard.values()) {
            if (!guard.rejectEdit(grid)) continue;
            return guard;
        }
        return null;
    }

    @NotNull
    private static String defaultMessage() {
        String string = EditorBundle.message((String)"editing.viewer.hint", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/GridEditGuard", "defaultMessage"));
        }
        return string;
    }
}

