/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.operations.postgres;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.generation.DdlBuildingContext;
import com.intellij.database.schemaEditor.generation.DdlOperation;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.operations.ConfigurableDdlGenerator;
import com.intellij.database.schemaEditor.operations.DasDdlOperations;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PgRefreshMaterializedViewOperation
extends ConfigurableDdlGenerator<DeObject> {
    public static final ConfigurableDdlGenerator.Option<Boolean> WITH_NO_DATA = ConfigurableDdlGenerator.Option.create("With no data", Boolean.FALSE);

    public PgRefreshMaterializedViewOperation() {
        super(DasDdlOperations.REFRESH_MATERIALIZED_VIEW, WITH_NO_DATA);
    }

    @Override
    @NotNull
    public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeObject object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/postgres/PgRefreshMaterializedViewOperation", "generate"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/postgres/PgRefreshMaterializedViewOperation", "generate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/postgres/PgRefreshMaterializedViewOperation", "generate"));
        }
        Boolean noData = PgRefreshMaterializedViewOperation.findOption((Iterable)OPTION_VALUES.get(data), WITH_NO_DATA);
        builder.keywords("REFRESH", "MATERIALIZED", "VIEW").space().qualifiedRef(object);
        if (noData == Boolean.TRUE) {
            builder.space().keywords("WITH", "NO", "DATA");
        } else if (noData == Boolean.FALSE) {
            builder.space().keywords("WITH", "DATA");
        }
        DdlBuilder ddlBuilder = builder.newStatement();
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/postgres/PgRefreshMaterializedViewOperation", "generate"));
        }
        return ddlBuilder;
    }

    @Override
    public boolean isSupportedLight(@NotNull DdlOperation.DdlOperationSupport support, @NotNull ObjectKind kind) {
        if (support == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "support", "com/intellij/database/schemaEditor/operations/postgres/PgRefreshMaterializedViewOperation", "isSupportedLight"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/schemaEditor/operations/postgres/PgRefreshMaterializedViewOperation", "isSupportedLight"));
        }
        return kind == ObjectKind.MAT_VIEW;
    }
}

