/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.operations.sybase;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.generation.DdlBuildingContext;
import com.intellij.database.schemaEditor.generation.DdlGraph;
import com.intellij.database.schemaEditor.generation.DdlOperation;
import com.intellij.database.schemaEditor.generation.DdlOperationKey;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeRoutine;
import com.intellij.database.schemaEditor.operations.DasDdlOperations;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SybaseRenameRoutineOperation
extends DasDdlOperations.DdlOperationGeneratorSimple<DeRoutine> {
    public SybaseRenameRoutineOperation() {
        super(DasDdlOperations.RENAME_ROUTINE, DeRoutine.class, ObjectKind.ROUTINE);
    }

    @Override
    @NotNull
    public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeRoutine object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/sybase/SybaseRenameRoutineOperation", "generate"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/sybase/SybaseRenameRoutineOperation", "generate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/sybase/SybaseRenameRoutineOperation", "generate"));
        }
        DeObject target = this.getTarget(data);
        Application application = ApplicationManager.getApplication();
        String temp_schema = "sch" + (application == null || application.isUnitTestMode() ? "_tmp" : UUID.randomUUID().toString().substring(0, 4));
        builder.keyword("DECLARE").space().symbol("@").identifier(temp_schema).space().type("VARCHAR(255)").newLine();
        builder.keyword("SET").space().symbol("@").identifier(temp_schema).space().symbol("=").space().identifier("db_name").symbol("()").newLine();
        builder.keyword("USE").space().identifier(DasUtil.getCatalog((DasObject)object)).newLine();
        builder.keyword("EXEC").space().identifier("sp_rename").space().identifier(object, object.name).symbol(",").space().identifier(target, target.name).newLine();
        builder.keyword("USE").space().symbol("@").identifier(temp_schema);
        DbImplUtil.endStatement(builder);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/sybase/SybaseRenameRoutineOperation", "generate"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public JBIterable<DdlOperationKey> getImplemented(@NotNull DeRoutine object, @Nullable UserDataHolder data) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/sybase/SybaseRenameRoutineOperation", "getImplemented"));
        }
        JBIterable<DdlOperationKey> jBIterable = DdlGraph.notNullize(new DdlOperationKey(this.getTarget(data), DdlOperation.POST_RENAME));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/sybase/SybaseRenameRoutineOperation", "getImplemented"));
        }
        return jBIterable;
    }

    @NotNull
    public DeObject getTarget(@Nullable UserDataHolder data) {
        DeObject deObject = (DeObject)ObjectUtils.assertNotNull((Object)DdlGraph.ALTER_TO.get(data));
        if (deObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/sybase/SybaseRenameRoutineOperation", "getTarget"));
        }
        return deObject;
    }
}

