/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.mssql.MsDatabase;
import com.intellij.database.model.mssql.MsModel;
import com.intellij.database.model.mysql.MysqlModel;
import com.intellij.database.model.oracle.OraModel;
import com.intellij.database.model.postgres.PostgresDatabase;
import com.intellij.database.model.postgres.PostgresModel;
import com.intellij.database.scripting.AbstractScriptingService;
import com.intellij.database.scripting.GenericScriptingService;
import com.intellij.database.scripting.MsScriptingService;
import com.intellij.database.scripting.MysqlScriptingService;
import com.intellij.database.scripting.OraScriptingService;
import com.intellij.database.scripting.PostgresScriptingService;
import com.intellij.database.scripting.ScriptingFactory;
import com.intellij.database.scripting.ScriptingPreferences;
import com.intellij.database.scripting.ScriptingService;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/scripting/ModernScriptingFactory;", "Lcom/intellij/database/scripting/ScriptingFactory;", "()V", "createScriptingService", "Lcom/intellij/database/scripting/ScriptingService;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "preferences", "Lcom/intellij/database/scripting/ScriptingPreferences;", "database-scripting"})
public final class ModernScriptingFactory
implements ScriptingFactory {
    @Override
    @NotNull
    public ScriptingService createScriptingService(@NotNull BasicModel model, @Nullable BasicDatabase database, @Nullable ScriptingPreferences preferences) {
        AbstractScriptingService abstractScriptingService;
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        BasicDatabase basicDatabase = database;
        if (basicDatabase == null) {
            basicDatabase = model.getRoot().getCurrentDatabase();
        }
        if (basicDatabase == null) {
            throw (Throwable)new IllegalArgumentException("Database must be current or specified explicitly");
        }
        BasicDatabase db = basicDatabase;
        ScriptingPreferences scriptingPreferences = preferences;
        if (scriptingPreferences == null) {
            scriptingPreferences = new ScriptingPreferences(false, false, 3, null);
        }
        ScriptingPreferences prefs = scriptingPreferences;
        BasicModel basicModel = model;
        if (basicModel instanceof OraModel) {
            abstractScriptingService = new OraScriptingService((OraModel)model, prefs);
        } else if (basicModel instanceof PostgresModel) {
            BasicDatabase basicDatabase2 = db;
            if (basicDatabase2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.postgres.PostgresDatabase");
            }
            abstractScriptingService = new PostgresScriptingService((PostgresModel)model, (PostgresDatabase)basicDatabase2, prefs);
        } else if (basicModel instanceof MsModel) {
            BasicDatabase basicDatabase3 = db;
            if (basicDatabase3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.mssql.MsDatabase");
            }
            abstractScriptingService = new MsScriptingService((MsModel)model, (MsDatabase)basicDatabase3, prefs);
        } else {
            abstractScriptingService = basicModel instanceof MysqlModel ? (AbstractScriptingService)new MysqlScriptingService((MysqlModel)model, prefs) : (AbstractScriptingService)new GenericScriptingService(model, db, prefs);
        }
        AbstractScriptingService service = abstractScriptingService;
        service.init$database_scripting();
        return service;
    }
}

