/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.IntrospectionScopeUpdater;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.THashSet;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoaderContext {
    private final LocalDataSource myDataSource;
    private DatabaseFamilyId myFamilyId;
    private ErrorHandler myErrorHandler = new ErrorHandler();
    private final THashSet<Object> mySelection = new THashSet();
    private Object mySelectedElement;
    private boolean myNamespacesOnly = false;
    private final IntrospectionScopeUpdater myScopeUpdater = new IntrospectionScopeUpdater();

    public static LoaderContext loadAll(LocalDataSource dataSource) {
        return new LoaderContext(dataSource).includeAllSchemas().includeTables().includeProcedures();
    }

    @Deprecated
    public static LoaderContext loadOne(LocalDataSource dataSource, Object o) {
        return new LoaderContext(dataSource).include(o);
    }

    public LoaderContext(LocalDataSource dataSource) {
        this.myDataSource = dataSource;
        this.myFamilyId = DatabaseFamilyId.forDataSource((DatabaseSystem)this.myDataSource);
    }

    @NotNull
    public IntrospectionScopeUpdater getScopeUpdater() {
        IntrospectionScopeUpdater introspectionScopeUpdater = this.myScopeUpdater;
        if (introspectionScopeUpdater == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/LoaderContext", "getScopeUpdater"));
        }
        return introspectionScopeUpdater;
    }

    public void renewFamilyId(@NotNull DatabaseMetaData meta) throws SQLException {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/database/util/LoaderContext", "renewFamilyId"));
        }
        this.myDataSource.refreshDatabaseInfo(meta);
        this.myFamilyId = DatabaseFamilyId.forDataSource((DatabaseSystem)this.myDataSource);
    }

    public LocalDataSource getDataSource() {
        return this.myDataSource;
    }

    public DatabaseFamilyId getFamilyId() {
        return this.myFamilyId;
    }

    public Set<Object> getSelection() {
        return this.mySelection;
    }

    public LoaderContext setErrorHandler(ErrorHandler handler) {
        this.myErrorHandler = handler;
        return this;
    }

    public LoaderContext setNamespacesOnly(boolean namespacesOnly) {
        this.myNamespacesOnly = namespacesOnly;
        return this;
    }

    public boolean isSchemaListOnly() {
        return this.myNamespacesOnly;
    }

    public LoaderContext include(@Nullable Object o) {
        if (o == null) {
            return this;
        }
        if (o instanceof DasNamespace) {
            this.includeNamespace((DasNamespace)o);
        } else {
            this.mySelection.add(o instanceof DbElement ? ((DbElement)o).getDelegate() : o);
        }
        return this;
    }

    @Deprecated
    public LoaderContext includeSchema(String catalog, String schema) {
        this.mySelection.add((Object)LoaderContext.getPattern(catalog, schema));
        return this;
    }

    public LoaderContext includeNamespace(@NotNull DasNamespace namespace) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/database/util/LoaderContext", "includeNamespace"));
        }
        this.mySelection.add((Object)LoaderContext.getPatternFor(namespace, this.myFamilyId));
        return this;
    }

    @NotNull
    public static String getPatternFor(@NotNull DasNamespace namespace, DatabaseFamilyId familyId) {
        String pattern;
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/database/util/LoaderContext", "getPatternFor"));
        }
        ObjectKind namespaceKind = namespace.getKind();
        if (namespaceKind == ObjectKind.DATABASE) {
            pattern = LoaderContext.getPattern(namespace.getName(), null);
        } else if (namespaceKind == ObjectKind.SCHEMA) {
            DasObject parent = namespace.getDbParent();
            pattern = familyId.isOracle() ? LoaderContext.getPattern(null, namespace.getName()) : (parent != null && parent.getKind() == ObjectKind.DATABASE ? LoaderContext.getPattern(parent.getName(), namespace.getName()) : LoaderContext.getPattern(null, namespace.getName()));
        } else {
            throw new IllegalArgumentException("Strange kind of the given namespace: " + namespaceKind.name());
        }
        String string = pattern;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/LoaderContext", "getPatternFor"));
        }
        return string;
    }

    public LoaderContext includeAllSchemas() {
        this.mySelection.add((Object)LoaderContext.getPattern(null, null));
        return this;
    }

    public LoaderContext includeAllEntities() {
        return this.includeTables().includeProcedures();
    }

    public LoaderContext includeTables() {
        return this.include(DasTable.class);
    }

    public LoaderContext includeProcedures() {
        return this.include(DasRoutine.class);
    }

    public boolean loadNothing() {
        return this.mySelection.isEmpty() && !this.myNamespacesOnly;
    }

    public boolean load(Object o) {
        return this.mySelection.contains(o);
    }

    public boolean load(String catalog, String schema) {
        return this.mySelection.contains((Object)LoaderContext.getPattern(catalog, schema)) || this.mySelection.contains((Object)LoaderContext.getPattern(catalog, null)) || this.mySelection.contains((Object)LoaderContext.getPattern(null, null));
    }

    public ErrorHandler getErrorHandler() {
        return this.myErrorHandler;
    }

    public Object getElementToFocus() {
        return this.mySelectedElement;
    }

    public void setElementToFocus(@Nullable Object selectedElement) {
        this.mySelectedElement = selectedElement;
    }

    @NotNull
    public static String getPattern(@Nullable String catalog, @Nullable String schema) {
        if (StringUtil.isNotEmpty((String)catalog)) {
            if (StringUtil.isNotEmpty((String)schema)) {
                String string = catalog + "." + schema;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/LoaderContext", "getPattern"));
                }
                return string;
            }
            String string = catalog + ".*";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/LoaderContext", "getPattern"));
            }
            return string;
        }
        if (StringUtil.isNotEmpty((String)schema)) {
            String string = "*." + schema;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/LoaderContext", "getPattern"));
            }
            return string;
        }
        if ("*" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/LoaderContext", "getPattern"));
        }
        return "*";
    }
}

