/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vfs.fragment;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.ArrayUtil;
import icons.DatabaseIcons;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TableDataFragmentFile
extends LightVirtualFileBase {
    private final TextRange myRange;

    protected TableDataFragmentFile(@NotNull VirtualFile originalFile, @NotNull TextRange range) {
        if (originalFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFile", "com/intellij/database/vfs/fragment/TableDataFragmentFile", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/database/vfs/fragment/TableDataFragmentFile", "<init>"));
        }
        super(originalFile.getName() + " (fragment)", (FileType)MyFileType.INSTANCE, 0L);
        this.setOriginalFile(originalFile);
        this.myRange = range;
    }

    public boolean isValid() {
        return this.getOriginalFile().isValid();
    }

    @NotNull
    public TextRange getRange() {
        TextRange textRange = this.myRange;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/fragment/TableDataFragmentFile", "getRange"));
        }
        return textRange;
    }

    @NotNull
    public FileType getFileType() {
        MyFileType myFileType = MyFileType.INSTANCE;
        if (myFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/fragment/TableDataFragmentFile", "getFileType"));
        }
        return myFileType;
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw TableDataFragmentFile.throwNotSupported();
    }

    public InputStream getInputStream() throws IOException {
        throw TableDataFragmentFile.throwNotSupported();
    }

    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        if (ArrayUtil.EMPTY_BYTE_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/fragment/TableDataFragmentFile", "contentsToByteArray"));
        }
        return ArrayUtil.EMPTY_BYTE_ARRAY;
    }

    @NotNull
    private static IOException throwNotSupported() {
        IOException iOException = new IOException("Not supported");
        if (iOException == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/fragment/TableDataFragmentFile", "throwNotSupported"));
        }
        return iOException;
    }

    private static class MyFileType
    implements FileType {
        private static final MyFileType INSTANCE = new MyFileType();

        private MyFileType() {
        }

        @NotNull
        public String getName() {
            if ("Data Fragment" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/fragment/TableDataFragmentFile$MyFileType", "getName"));
            }
            return "Data Fragment";
        }

        @NotNull
        public String getDescription() {
            if ("A fragment of a file interpretable as a table" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/fragment/TableDataFragmentFile$MyFileType", "getDescription"));
            }
            return "A fragment of a file interpretable as a table";
        }

        @NotNull
        public String getDefaultExtension() {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vfs/fragment/TableDataFragmentFile$MyFileType", "getDefaultExtension"));
            }
            return "";
        }

        @Nullable
        public Icon getIcon() {
            return DatabaseIcons.Table;
        }

        public boolean isBinary() {
            return false;
        }

        public boolean isReadOnly() {
            return true;
        }

        @Nullable
        public String getCharset(@NotNull VirtualFile file, @NotNull byte[] content) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/vfs/fragment/TableDataFragmentFile$MyFileType", "getCharset"));
            }
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/database/vfs/fragment/TableDataFragmentFile$MyFileType", "getCharset"));
            }
            return null;
        }
    }
}

