/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.view.editors.DatabaseColumnRefEditor;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.database.view.editors.DatabaseKeyEditor;
import com.intellij.database.view.models.EditorModelUtil;
import com.intellij.database.view.models.TableKeyEditorModel;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class DatabaseKeyColumnEditor
implements DatabaseEditorUtil.EmbeddableEditor {
    private final DatabaseKeyEditor myKeyEditor;
    private final DatabaseEditorCapabilities.TableKeyColumnEditorCaps myCaps;
    private JPanel myPanel;
    private EditorTextField myColumnEditorComponent;
    private final DatabaseColumnRefEditor myColumnEditor;
    private boolean myValid;

    public DatabaseKeyColumnEditor(@NotNull DatabaseKeyEditor keyEditor, @NotNull DatabaseEditorCapabilities.TableKeyColumnEditorCaps caps) {
        if (keyEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyEditor", "com/intellij/database/view/editors/DatabaseKeyColumnEditor", "<init>"));
        }
        if (caps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caps", "com/intellij/database/view/editors/DatabaseKeyColumnEditor", "<init>"));
        }
        this.myKeyEditor = keyEditor;
        this.myCaps = caps;
        this.myColumnEditor = new DatabaseColumnRefEditor(this.myKeyEditor.getContext());
        this.$$$setupUI$$$();
        this.myColumnEditorComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                if (!((DatabaseKeyColumnEditor)DatabaseKeyColumnEditor.this).myKeyEditor.myUpdating) {
                    ArrayList columns = ContainerUtil.newArrayList(DatabaseKeyColumnEditor.this.getTableKeyModel().getColumns());
                    int index = DatabaseKeyColumnEditor.this.myKeyEditor.getIndex(DatabaseKeyColumnEditor.this);
                    DeColumn column = DatabaseKeyColumnEditor.this.getColumn();
                    columns.set(index, column);
                    DatabaseKeyColumnEditor.this.getTableKeyModel().setColumns(columns);
                    DatabaseKeyColumnEditor.this.getTableKeyModel().commit();
                }
            }
        });
    }

    @NotNull
    public TableKeyEditorModel getTableKeyModel() {
        TableKeyEditorModel tableKeyEditorModel = this.myKeyEditor.getTableKeyModel();
        if (tableKeyEditorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseKeyColumnEditor", "getTableKeyModel"));
        }
        return tableKeyEditorModel;
    }

    @Override
    @NotNull
    public Iterable<Pair<String, TextAttributesKey>> getRowText() {
        DeColumn column = this.getColumn();
        Iterable<Pair<String, TextAttributesKey>> iterable = new DatabaseEditorUtil.ColoredFragmentsBuilder().appendRef(this.myKeyEditor.getObjectName(column), DatabaseEditorBaseEx.isGood(column)).build();
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseKeyColumnEditor", "getRowText"));
        }
        return iterable;
    }

    @Override
    public boolean isObjectValid() {
        return this.myValid;
    }

    @Override
    public boolean canDoAnything() {
        return true;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseKeyColumnEditor", "getComponent"));
        }
        return jPanel;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.myColumnEditorComponent.getFocusTarget();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseKeyColumnEditor", "getPreferredFocusedComponent"));
        }
        return jComponent;
    }

    @Override
    @NotNull
    public JComponent[] getFocusableComponents() {
        JComponent[] jComponentArray = new JComponent[]{this.myColumnEditorComponent.getFocusTarget()};
        if (jComponentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseKeyColumnEditor", "getFocusableComponents"));
        }
        return jComponentArray;
    }

    @NotNull
    public DeColumn getColumn() {
        DeColumn deColumn = this.myColumnEditor.getObjectOrStub(this.myKeyEditor.getTable());
        if (deColumn == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseKeyColumnEditor", "getColumn"));
        }
        return deColumn;
    }

    public void updateFromModel(int idx) {
        DeColumn column = this.getTableKeyModel().getColumns().get(idx);
        this.myColumnEditor.setTable(this.myKeyEditor.getTable());
        this.myColumnEditor.setObject(column);
        this.myValid = column != null && !EditorModelUtil.isStub(column) && column.isInTable();
    }

    @NotNull
    public EditorTextField getColumnEditor() {
        EditorTextField editorTextField = this.myColumnEditorComponent;
        if (editorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseKeyColumnEditor", "getColumnEditor"));
        }
        return editorTextField;
    }

    private void createUIComponents() {
        this.myColumnEditorComponent = this.myColumnEditor.getEditor();
    }

    @NotNull
    public DatabaseKeyEditor getKeyEditor() {
        DatabaseKeyEditor databaseKeyEditor = this.myKeyEditor;
        if (databaseKeyEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseKeyColumnEditor", "getKeyEditor"));
        }
        return databaseKeyEditor;
    }

    @NotNull
    public DatabaseEditorCapabilities.TableKeyColumnEditorCaps getCaps() {
        DatabaseEditorCapabilities.TableKeyColumnEditorCaps tableKeyColumnEditorCaps = this.myCaps;
        if (tableKeyColumnEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseKeyColumnEditor", "getCaps"));
        }
        return tableKeyColumnEditorCaps;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Name:");
        jBLabel.setDisplayedMnemonic('N');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField = this.myColumnEditorComponent;
        jPanel.add((Component)editorTextField, new GridConstraints(1, 0, 1, 1, 0, 1, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

