/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.autoconfig.DataSourceConfigUtil;
import com.intellij.database.autoconfig.DataSourceRegistry;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceManagerEx;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.psi.DefaultDbPsiManager;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.ui.DataSourceSettings;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseConfigEditorImpl;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorConfigurable;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceManagerDialog
extends SingleConfigurableEditor {
    private DataSourceManagerDialog(@NotNull DbPsiFacade facade, @NotNull DataSourceSettings settings) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/database/view/ui/DataSourceManagerDialog", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/view/ui/DataSourceManagerDialog", "<init>"));
        }
        super(facade.getProject(), (Configurable)new MyConfigurable(settings));
        this.setTitle("Data Sources and Drivers");
        this.setHorizontalStretch(1.3f);
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        DialogWrapper.DialogStyle dialogStyle = DialogWrapper.DialogStyle.COMPACT;
        if (dialogStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DataSourceManagerDialog", "getStyle"));
        }
        return dialogStyle;
    }

    @NotNull
    public static List<DbDataSource> showDialog(@NotNull Project project, @Nullable DbDataSource selection) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/view/ui/DataSourceManagerDialog", "showDialog"));
        }
        List<DbDataSource> list = DataSourceManagerDialog.showDialog(DbPsiFacade.getInstance((Project)project), selection);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DataSourceManagerDialog", "showDialog"));
        }
        return list;
    }

    @NotNull
    public static List<DbDataSource> showDialog(@NotNull DbPsiFacade facade, @Nullable DbDataSource selection) {
        DatabaseView view2;
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/database/view/ui/DataSourceManagerDialog", "showDialog"));
        }
        DataSourceSettings settings = new DataSourceSettings(facade, selection);
        if (selection != null && !selection.isValid()) {
            settings.addNewDataSource(selection);
        }
        HashSet existing = ContainerUtil.newHashSet(settings.getDataSources());
        DataSourceManagerDialog dialog = new DataSourceManagerDialog(facade, settings);
        dialog.show();
        ArrayList result = ContainerUtil.newArrayList();
        if (ModalityState.current() == ModalityState.NON_MODAL) {
            for (DbDataSource element : settings.getDataSources()) {
                if (existing.contains(element)) continue;
                result.add(element);
                if (!DbImplUtil.canConnectTo((DbElement)element)) continue;
                DatabaseEditorHelper.openConsoleFile((DbElement)element);
            }
        }
        if ((view2 = DatabaseView.getDatabaseView(facade.getProject())) != null && !result.isEmpty()) {
            view2.selectElements(result.toArray(new DbElement[result.size()]));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DataSourceManagerDialog", "showDialog"));
        }
        return arrayList;
    }

    public static void showDialog(final @NotNull DbPsiFacade facade, final @NotNull DataSourceRegistry registry) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/database/view/ui/DataSourceManagerDialog", "showDialog"));
        }
        if (registry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registry", "com/intellij/database/view/ui/DataSourceManagerDialog", "showDialog"));
        }
        new DialogCreator(facade){

            @Override
            protected void doCreate() {
                DataSourceManagerEx dataSourceManager = DataSourceManagerEx.getInstanceEx(facade.getProject());
                for (LocalDataSource o : registry.getDataSources()) {
                    LocalDataSource existing = (LocalDataSource)((Object)ObjectUtils.tryCast((Object)dataSourceManager.getDataSourceByName(o.getName()), LocalDataSource.class));
                    if (existing != null && o.isImported()) continue;
                    this.addDataSource(o);
                }
            }

            @Override
            protected void doUpdate(@NotNull DatabaseConfigEditor editor) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/view/ui/DataSourceManagerDialog$1", "doUpdate"));
                }
                DataSourceManagerEx dataSourceManager = DataSourceManagerEx.getInstanceEx(facade.getProject());
                for (LocalDataSource o : registry.getDataSources()) {
                    DataSourceConfigurable configurable;
                    LocalDataSource existing = (LocalDataSource)((Object)ObjectUtils.tryCast((Object)dataSourceManager.getDataSourceByName(o.getName()), LocalDataSource.class));
                    if (existing == null || !o.isImported() || (configurable = editor.getConfigurable(existing, true, DataSourceConfigurable.class)) == null) continue;
                    LocalDataSource temp = configurable.getTempDataSource();
                    temp.setUrlSmart(o.getUrl());
                    configurable.resetFromTemp();
                }
            }
        }.create();
        DataSourceConfigUtil.runRegistryCallbacks(facade.getProject(), registry);
    }

    public static void showLocalDataSourcesDialog(@NotNull DbPsiFacade facade, final @NotNull Collection<LocalDataSource> dataSources) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/database/view/ui/DataSourceManagerDialog", "showLocalDataSourcesDialog"));
        }
        if (dataSources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSources", "com/intellij/database/view/ui/DataSourceManagerDialog", "showLocalDataSourcesDialog"));
        }
        new DialogCreator(facade){

            @Override
            protected void doCreate() {
                for (LocalDataSource dataSource : dataSources) {
                    this.addDataSource(dataSource);
                }
            }

            @Override
            protected void doUpdate(@NotNull DatabaseConfigEditor editor) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/view/ui/DataSourceManagerDialog$2", "doUpdate"));
                }
            }
        }.create();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.execution.impl.EditConfigurationsDialog";
    }

    protected void doOKAction() {
        super.doOKAction();
    }

    private static class MyConfigurable
    extends SettingsEditorConfigurable<DataSourceSettings> {
        public MyConfigurable(DataSourceSettings settings) {
            super((SettingsEditor)new DatabaseConfigEditorImpl(settings), (Object)settings);
        }

        public String getDisplayName() {
            return "Data Sources";
        }

        public String getHelpTopic() {
            String topic = this.getEditor().getHelpTopic();
            if (topic == null) {
                topic = "reference.tools.datasource.properties";
            }
            return topic;
        }

        public DatabaseConfigEditorImpl getEditor() {
            return (DatabaseConfigEditorImpl)super.getEditor();
        }

        public boolean isModified() {
            return this.getEditor().isAnyEditorModified();
        }

        public JComponent getPreferredFocusedComponent() {
            return this.getEditor().getPreferredFocusedComponent();
        }
    }

    private static abstract class DialogCreator {
        private final DbPsiFacade myFacade;
        private final DataSourceSettings mySettings;
        private final DefaultDbPsiManager myPsiManager;

        public DialogCreator(DbPsiFacade facade) {
            this.myFacade = facade;
            this.mySettings = new DataSourceSettings(this.myFacade, null);
            this.myPsiManager = (DefaultDbPsiManager)((Object)ContainerUtil.findInstance((Iterable)this.myFacade.getDbManagers(), DefaultDbPsiManager.class));
        }

        public void create() {
            if (this.myPsiManager != null) {
                this.doCreate();
            }
            DataSourceManagerDialog dialog = new DataSourceManagerDialog(this.myFacade, this.mySettings);
            DatabaseConfigEditorImpl editor = ((MyConfigurable)dialog.getConfigurable()).getEditor();
            this.doUpdate(editor);
            editor.clearModifiedCache();
            dialog.show();
        }

        protected void addDataSource(LocalDataSource dataSource) {
            if (dataSource.getDatabaseDriver() == null) {
                if (StringUtil.isEmpty((String)dataSource.getDriverClass())) {
                    return;
                }
                DatabaseDriver newDriver = null;
                for (DatabaseDriver driver : this.mySettings.getNewDrivers()) {
                    if (!dataSource.getDriverClass().equals(driver.getDriverClass())) continue;
                    newDriver = driver;
                    break;
                }
                if (newDriver == null) {
                    newDriver = DatabaseDriverManager.getInstance().createDriver(dataSource.getDriverClass(), dataSource.getDriverClass(), null);
                    this.mySettings.addNewDriver(newDriver);
                }
                dataSource.setDatabaseDriver(newDriver);
            } else if (!DatabaseDriverManager.getInstance().getDrivers().contains(dataSource.getDatabaseDriver())) {
                this.mySettings.addNewDriver(dataSource.getDatabaseDriver());
            }
            DbDataSource element = ((DbPsiFacadeImpl)this.myFacade).createDataSourceWrapperElement((DatabaseSystem)dataSource, this.myPsiManager);
            this.mySettings.addNewDataSource(element);
            if (this.mySettings.getNewDataSources().size() == 1) {
                this.mySettings.setCurrentDataSource(element);
            }
        }

        protected abstract void doCreate();

        protected abstract void doUpdate(@NotNull DatabaseConfigEditor var1);
    }
}

