/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.DocumentationProviderEx;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlAlterTableInstruction;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlElementDescriptionProvider;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDocumentationProvider
extends DocumentationProviderEx {
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        BuiltinFunction definition;
        if (element instanceof SqlDefinition) {
            SqlDefinition definition2 = (SqlDefinition)element;
            String kindName = SqlElementDescriptionProvider.getKindName(definition2);
            return kindName + " " + QNameUtil.getQualifiedName((DasObject)definition2);
        }
        if (element instanceof SqlFunctionCallExpression && (definition = ((SqlFunctionCallExpression)element).getFunctionDefinition()) != null) {
            return definition.getName();
        }
        return null;
    }

    public String generateDoc(PsiElement element, PsiElement originalElement) {
        if (element instanceof SqlDefinition) {
            PsiElement textElement = element.getParent() instanceof SqlAlterTableInstruction ? element.getParent() : element;
            SqlDefinition definition = (SqlDefinition)element;
            String kindName = SqlElementDescriptionProvider.getKindName(definition);
            return kindName + " <b>" + QNameUtil.getQualifiedName((DasObject)definition) + "</b><br><pre><code>" + DbSqlUtil.sql2Html(element.getProject(), (Language)SqlImplUtil.getSqlDialectSafe(element), (CharSequence)ObjectUtils.notNull((Object)textElement.getText(), (Object)"")) + "</code></pre>";
        }
        if (element instanceof SqlFunctionCallExpression) {
            Class<?> dialectClass = element.getContainingFile().getLanguage().getClass();
            SqlFunctionCallExpression callExpression = (SqlFunctionCallExpression)element;
            BuiltinFunction definition = callExpression.getFunctionDefinition();
            if (definition instanceof SqlFunctionDefinition) {
                return SqlDocumentationProvider.getDocumentation((SqlFunctionDefinition)definition, SqlFunctionsUtil.chooseTheBestPrototype(callExpression, false), dialectClass);
            }
        }
        return null;
    }

    @Nullable
    public static String getDocumentation(@NotNull SqlFunctionDefinition definition, @Nullable SqlFunctionDefinition.Prototype prototype, @NotNull Class<? extends Language> dialectClass) {
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/intellij/sql/SqlDocumentationProvider", "getDocumentation"));
        }
        if (dialectClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialectClass", "com/intellij/sql/SqlDocumentationProvider", "getDocumentation"));
        }
        int protypeId = prototype == null ? 0 : prototype.getPrototypeId();
        String name = definition.getAliasedFunction();
        String basePath = "functions/" + name.replace('@', '_');
        if (protypeId > 0) {
            try {
                return SqlDialectImplUtil.getDialectHelpResource(dialectClass, basePath + "-" + protypeId + ".html");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            return SqlDialectImplUtil.getDialectHelpResource(dialectClass, basePath + ".html");
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (object instanceof SqlFunctionDefinition.Prototype && element != null) {
            SqlFunctionDefinition.Prototype prototype = (SqlFunctionDefinition.Prototype)object;
            SqlExpression expr = SqlPsiElementFactory.createExpressionFromText(prototype.getFunction().getName() + "()", SqlImplUtil.getSqlDialectSafe(element), psiManager.getProject(), null);
            SqlFunctionsUtil.setExplicitPrototype(expr, prototype);
            return expr;
        }
        return null;
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file, @Nullable PsiElement contextElement) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/SqlDocumentationProvider", "getCustomDocumentationElement"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/SqlDocumentationProvider", "getCustomDocumentationElement"));
        }
        DbElement element = (DbElement)SqlDocumentationProvider.findRelatedViewElements(TargetElementUtil.findReference((Editor)editor), null).filter(DbImplUtil.CAN_CONNECT_TO).first();
        return element == null ? super.getCustomDocumentationElement(editor, file, contextElement) : element;
    }

    @NotNull
    public static JBIterable<DbElement> findRelatedViewElements(@Nullable PsiReference refAt, @Nullable SqlDefinition definition) {
        SqlReferenceImpl targetRef;
        SqlReferenceElementType refType;
        String refText;
        SqlDefinition element;
        SqlReferenceImpl ref;
        if (refAt instanceof SqlReferenceImpl) {
            ref = (SqlReferenceImpl)refAt;
        } else if (definition != null) {
            SqlNameElement nameElement = definition.getNameElement();
            if (definition.getKind() == ObjectKind.BODY && nameElement != null && nameElement.getLastChild() instanceof SqlReferenceExpression) {
                nameElement = (SqlNameElement)nameElement.getLastChild();
            }
            PsiReference nameRef = nameElement != null ? nameElement.getReference() : null;
            ref = nameRef instanceof SqlReferenceImpl ? (SqlReferenceImpl)nameRef : null;
        } else {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlDocumentationProvider", "findRelatedViewElements"));
            }
            return jBIterable;
        }
        if (ref != null) {
            element = ref.getElement();
            refText = ref.getCanonicalText();
            refType = ref.getReferenceElementType();
        } else {
            element = definition;
            refText = QNameUtil.getQualifiedName((DasObject)definition);
            refType = definition.getKind() == ObjectKind.COLUMN ? SqlCompositeElementTypes.SQL_COLUMN_REFERENCE : SqlCompositeElementTypes.SQL_REFERENCE;
        }
        SqlReferenceExpression newRef = SqlPsiElementFactory.createReferenceFromText(refText, SqlImplUtil.getSqlDialectSafe((PsiElement)element), refType, (PsiElement)element);
        SqlReferenceImpl sqlReferenceImpl = targetRef = newRef == null ? ref : newRef.getReference();
        if (targetRef == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlDocumentationProvider", "findRelatedViewElements"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.of((Object[])targetRef.multiResolve(false)).transform(result -> result.getElement()).filter(DbElement.class);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlDocumentationProvider", "findRelatedViewElements"));
        }
        return jBIterable;
    }
}

