/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.introduce.inplace.InplaceVariableIntroducer;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlIntroduceVariableHandler
implements RefactoringActionHandler {
    private static void performInplaceIntroduce(@NotNull Editor editor, @NotNull SqlExpression expression, boolean replaceAll) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/SqlIntroduceVariableHandler", "performInplaceIntroduce"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/sql/SqlIntroduceVariableHandler", "performInplaceIntroduce"));
        }
        List occurrences = replaceAll ? SqlIntroduceVariableHandler.getOccurrences(expression) : ContainerUtil.list((Object[])new PsiElement[]{expression});
        SqlExtractVariableHelper helper = SqlImplUtil.getSqlDialectSafe((PsiElement)expression).getExtractVariableHelper();
        if (helper == null) {
            return;
        }
        PsiElement declaration = SqlIntroduceVariableHandler.performElement(editor, expression, occurrences, helper);
        if (declaration != null && declaration.isValid()) {
            PsiElement target = (PsiElement)SqlImplUtil.sqlTraverser().filter(SqlVariableDefinition.class).first();
            if (target == null || !target.isValid()) {
                return;
            }
            editor.getCaretModel().moveToOffset(target.getTextRange().getStartOffset());
            SqlTypeElement type = helper.getTypeElement(target);
            SqlInplaceVariableIntroducer introducer = new SqlInplaceVariableIntroducer(expression.getProject(), editor, (PsiNamedElement)target, type, occurrences);
            introducer.performInplaceRefactoring(ContainerUtil.newLinkedHashSet());
        }
    }

    @Nullable
    private static PsiElement performElement(@NotNull Editor editor, @NotNull SqlExpression expression, final @NotNull List<PsiElement> occurrences, final @NotNull SqlExtractVariableHelper helper) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/SqlIntroduceVariableHandler", "performElement"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/sql/SqlIntroduceVariableHandler", "performElement"));
        }
        if (occurrences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "occurrences", "com/intellij/sql/SqlIntroduceVariableHandler", "performElement"));
        }
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/sql/SqlIntroduceVariableHandler", "performElement"));
        }
        final Project project = expression.getProject();
        String name = "new_var";
        String type = "int";
        final PsiElement initializer = helper.createInitializerDeclaration(project, "new_var", expression.getText());
        final PsiElement declaration = helper.createDeclaration(project, "new_var", type);
        final PsiElement anchor = helper.findInitializerAnchor(occurrences);
        final PsiElement block = helper.findTopmostBlock((PsiElement)expression);
        if (declaration == null || initializer == null || anchor == null || block == null) {
            SqlIntroduceVariableHandler.showCannotPerformError(project, editor);
            return null;
        }
        final SqlLanguageDialectEx language = SqlImplUtil.getSqlDialectSafe((PsiElement)expression);
        final PsiFile file = expression.getContainingFile();
        return (PsiElement)new WriteCommandAction<PsiElement>(project, "Extract variable", new PsiFile[]{file}){

            protected void run(@NotNull Result<PsiElement> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/SqlIntroduceVariableHandler$1", "run"));
                }
                PsiDocumentManager dm = PsiDocumentManager.getInstance((Project)project);
                Document document = dm.getDocument(file);
                if (document == null) {
                    return;
                }
                dm.commitDocument(document);
                PsiElement createdDeclaration = helper.addDeclaration(declaration, block);
                SqlIntroduceVariableHandler.addInitializer(project, anchor, initializer, language);
                SqlExpression newExpression = SqlPsiElementFactory.createExpressionFromText("new_var", language, project, null);
                if (newExpression != null) {
                    for (PsiElement occurrence : occurrences) {
                        occurrence.replace((PsiElement)newExpression);
                    }
                }
                if (createdDeclaration != null) {
                    createdDeclaration = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)createdDeclaration);
                }
                result.setResult((Object)createdDeclaration);
            }
        }.execute().getResultObject();
    }

    private static void addInitializer(Project project, PsiElement anchor, PsiElement initializer, @NotNull SqlLanguageDialect language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/sql/SqlIntroduceVariableHandler", "addInitializer"));
        }
        PsiElement createdInitializer = anchor.getParent().addBefore(initializer, anchor);
        if (createdInitializer != null) {
            PsiElement semi = SqlPsiElementFactory.createLeafFromText(project, language, ";");
            PsiElement newLineNode = SqlPsiElementFactory.newLine(project);
            PsiElement parent = createdInitializer.getParent();
            PsiElement psiElement = parent.addAfter(semi, createdInitializer);
            parent.addAfter(newLineNode, psiElement);
        }
    }

    @Nullable
    private static SqlExpression getSelectedExpression(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        if (element1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element1", "com/intellij/sql/SqlIntroduceVariableHandler", "getSelectedExpression"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element2", "com/intellij/sql/SqlIntroduceVariableHandler", "getSelectedExpression"));
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (parent == null) {
            return null;
        }
        if (parent instanceof SqlExpression) {
            return (SqlExpression)parent;
        }
        return (SqlExpression)PsiTreeUtil.getParentOfType((PsiElement)parent, SqlExpression.class);
    }

    private static boolean checkIntroduceContext(@NotNull PsiFile file, @NotNull Editor editor, @Nullable PsiElement element) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/SqlIntroduceVariableHandler", "checkIntroduceContext"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/SqlIntroduceVariableHandler", "checkIntroduceContext"));
        }
        if (!SqlIntroduceVariableHandler.isValidIntroduceContext(element)) {
            SqlIntroduceVariableHandler.showCannotPerformError(file.getProject(), editor);
            return false;
        }
        return true;
    }

    private static void showCannotPerformError(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/SqlIntroduceVariableHandler", "showCannotPerformError"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/SqlIntroduceVariableHandler", "showCannotPerformError"));
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Cannot perform refactoring", (String)"Cannot Perform Refactoring", (String)"refactoring.extractMethod");
    }

    private static boolean isValidIntroduceContext(@Nullable PsiElement element) {
        return SqlIntroduceVariableHandler.getTopmostScope(element) != null;
    }

    @Nullable
    public static PsiElement getTopmostScope(@Nullable PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)element, SqlBlockStatementImpl.class);
    }

    private static void smartIntroduce(final @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/SqlIntroduceVariableHandler", "smartIntroduce"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/SqlIntroduceVariableHandler", "smartIntroduce"));
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement e = file.findElementAt(offset);
        if (!SqlIntroduceVariableHandler.checkIntroduceContext(file, editor, e)) {
            return;
        }
        ArrayList<SqlExpression> expressions = new ArrayList<SqlExpression>();
        while (e != null && !(e instanceof SqlStatement) && !(e instanceof SqlQueryExpression)) {
            if (e instanceof SqlExpression && !SqlIntroduceVariableHandler.isCallExpression(e)) {
                expressions.add((SqlExpression)e);
            }
            e = e.getParent();
        }
        if (expressions.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            SqlIntroduceVariableHandler.performOnElement(editor, (SqlExpression)expressions.get(0));
        } else if (expressions.size() > 1) {
            IntroduceTargetChooser.showChooser((Editor)editor, expressions, (Pass)new Pass<SqlExpression>(){

                public void pass(@NotNull SqlExpression expression) {
                    if (expression == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/sql/SqlIntroduceVariableHandler$2", "pass"));
                    }
                    SqlIntroduceVariableHandler.performOnElement(editor, expression);
                }
            }, expression -> expression.getText());
        }
    }

    private static boolean isCallExpression(@Nullable PsiElement e) {
        return e instanceof SqlReferenceExpression && ((SqlReferenceExpression)e).getReferenceElementType() == SqlCompositeElementTypes.SQL_ANY_CALLABLE_REFERENCE;
    }

    private static void performOnElement(final @NotNull Editor editor, final @NotNull SqlExpression expression) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/SqlIntroduceVariableHandler", "performOnElement"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/sql/SqlIntroduceVariableHandler", "performOnElement"));
        }
        if (!editor.getSettings().isVariableInplaceRenameEnabled()) {
            return;
        }
        OccurrencesChooser.simpleChooser((Editor)editor).showChooser((Object)expression, SqlIntroduceVariableHandler.getOccurrences(expression), (Pass)new Pass<OccurrencesChooser.ReplaceChoice>(){

            public void pass(OccurrencesChooser.ReplaceChoice replaceChoice) {
                SqlIntroduceVariableHandler.performInplaceIntroduce(editor, expression, replaceChoice == OccurrencesChooser.ReplaceChoice.ALL);
            }
        });
    }

    @NotNull
    static List<PsiElement> getOccurrences(@NotNull SqlExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/sql/SqlIntroduceVariableHandler", "getOccurrences"));
        }
        PsiElement scope = SqlIntroduceVariableHandler.getTopmostScope((PsiElement)expression);
        List list = scope == null ? Collections.emptyList() : ((SyntaxTraverser)SqlImplUtil.sqlTraverser(scope).filter(element -> {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/sql/SqlIntroduceVariableHandler", "lambda$getOccurrences$1"));
            }
            return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)element, (PsiElement)expression);
        })).toList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlIntroduceVariableHandler", "getOccurrences"));
        }
        return list;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/SqlIntroduceVariableHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/sql/SqlIntroduceVariableHandler", "invoke"));
        }
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/SqlIntroduceVariableHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/SqlIntroduceVariableHandler", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/SqlIntroduceVariableHandler", "invoke"));
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)file)) {
            return;
        }
        SqlExtractVariableHelper helper = SqlImplUtil.getSqlDialectSafe((PsiElement)file).getExtractVariableHelper();
        if (helper == null) {
            SqlIntroduceVariableHandler.showCannotPerformError(project, editor);
            return;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            PsiElement element1 = file.findElementAt(selectionModel.getSelectionStart());
            PsiElement element2 = file.findElementAt(selectionModel.getSelectionEnd() - 1);
            if (element1 instanceof PsiWhiteSpace) {
                element1 = file.findElementAt(element1.getTextRange().getEndOffset());
            }
            if (element2 instanceof PsiWhiteSpace) {
                element2 = file.findElementAt(element2.getTextRange().getStartOffset() - 1);
            }
            if (element1 == null || element2 == null) {
                SqlIntroduceVariableHandler.showCannotPerformError(project, editor);
                return;
            }
            SqlExpression selectedExpression = SqlIntroduceVariableHandler.getSelectedExpression(element1, element2);
            if (selectedExpression == null || helper.findTopmostBlock((PsiElement)selectedExpression) == null) {
                SqlIntroduceVariableHandler.showCannotPerformError(project, editor);
            } else {
                SqlIntroduceVariableHandler.performOnElement(editor, selectedExpression);
            }
            return;
        }
        SqlIntroduceVariableHandler.smartIntroduce(editor, file);
    }

    private static class SqlInplaceVariableIntroducer
    extends InplaceVariableIntroducer<PsiElement> {
        @NotNull
        private final PsiElement myTarget;
        @Nullable
        private final SqlTypeElement myTypeElement;

        public SqlInplaceVariableIntroducer(@NotNull Project project, @NotNull Editor editor, @NotNull PsiNamedElement target, @Nullable SqlTypeElement typeElement, @NotNull List<PsiElement> occurrences) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/SqlIntroduceVariableHandler$SqlInplaceVariableIntroducer", "<init>"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/SqlIntroduceVariableHandler$SqlInplaceVariableIntroducer", "<init>"));
            }
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/sql/SqlIntroduceVariableHandler$SqlInplaceVariableIntroducer", "<init>"));
            }
            if (occurrences == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "occurrences", "com/intellij/sql/SqlIntroduceVariableHandler$SqlInplaceVariableIntroducer", "<init>"));
            }
            super(target, editor, project, "Introduce Variable", occurrences.toArray(new PsiElement[occurrences.size()]), null);
            this.myTarget = target;
            this.myTypeElement = typeElement;
        }

        protected PsiElement checkLocalScope() {
            return this.myTarget.getContainingFile();
        }

        protected void addAdditionalVariables(@NotNull TemplateBuilderImpl builder) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/sql/SqlIntroduceVariableHandler$SqlInplaceVariableIntroducer", "addAdditionalVariables"));
            }
            if (this.myTypeElement != null) {
                builder.replaceElement((PsiElement)this.myTypeElement, this.myTypeElement.getText());
            }
        }
    }
}

