/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.dbm.common.IntrospectionScope;
import com.intellij.lang.LanguagePerFileMappings;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.sql.dialects.TreePatternSerialization;
import com.intellij.sql.dialects.TreePatternUtils;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import com.thoughtworks.xstream.io.json.JsonWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="SqlResolveMappings", storages={@Storage(value="sqldialects.xml")})
public class SqlResolveMappings
extends LanguagePerFileMappings<TreePattern> {
    private static final JsonWriter.Format JSON_FORMAT = new JsonWriter.Format(new char[]{' '}, new char[]{' '}, JsonWriter.Format.COMPACT_EMPTY_ELEMENT);
    public static final TreePattern ALL_DATA_SOURCES = new TreePattern(TreePatternUtils.create((ObjectName)null, SqlImportUtil.DATA_SOURCE, new TreePatternNode.Group[0]));

    public static SqlResolveMappings getInstance(Project project) {
        return (SqlResolveMappings)((Object)ServiceManager.getService((Project)project, SqlResolveMappings.class));
    }

    public SqlResolveMappings(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/dialects/SqlResolveMappings", "<init>"));
        }
        super(project);
    }

    @NotNull
    protected String getValueAttribute() {
        if ("scope" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlResolveMappings", "getValueAttribute"));
        }
        return "scope";
    }

    public List<TreePattern> getAvailableValues() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected String serialize(TreePattern pattern) {
        StringWriter res = new StringWriter();
        try (JsonWriter writer = new JsonWriter((Writer)res, JSON_FORMAT);){
            TreePatternSerialization.serialize((HierarchicalStreamWriter)writer, pattern);
        }
        return res.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected TreePattern handleUnknownMapping(VirtualFile file, String value) {
        if (StringUtil.isEmpty((String)value)) {
            return TreePattern.EMPTY;
        }
        try (HierarchicalStreamReader reader = new JettisonMappedXmlDriver().createReader((Reader)new StringReader(value));){
            TreePattern treePattern = TreePatternSerialization.deserialize(reader);
            return treePattern;
        }
    }

    @Nullable
    public TreePattern getDefaultMapping(@Nullable VirtualFile file) {
        return ALL_DATA_SOURCES;
    }

    public static void migrateUnqualified(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/dialects/SqlResolveMappings", "migrateUnqualified"));
        }
        SqlResolveMappings mapping = SqlResolveMappings.getInstance(project);
        List dataSources = DbPsiFacade.getInstance((Project)project).getDataSources();
        TreePattern unqualified = TreePatternUtils.sorted(TreePatternUtils.union((Iterable<TreePattern>)JBIterable.from((Iterable)dataSources).transform(ds -> {
            IntrospectionScope scope;
            TreePatternNode.Group root2 = null;
            LocalDataSource localDataSource = (LocalDataSource)((Object)((Object)ObjectUtils.tryCast((Object)ds.getDelegate(), LocalDataSource.class)));
            IntrospectionScope introspectionScope = scope = localDataSource == null ? null : localDataSource.myResolveScope;
            if (scope != null && !scope.isEmpty()) {
                boolean database = DbImplUtil.getDatabaseDialect((DbElement)ds).getMetaModel().getRootNamespaceKinds().contains((Object)ObjectKind.DATABASE);
                root2 = SqlImportUtil.getRootGroup(!database, scope.to((MultiMap<String, String>)MultiMap.createLinked()), true);
            }
            return new TreePattern(TreePatternUtils.create(SqlImportUtil.getDataSourceName((DatabaseSystem)ds), SqlImportUtil.DATA_SOURCE, root2));
        })));
        mapping.setMapping(null, unqualified);
    }
}

