/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle.plus;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.dialects.oracle.OracleDialect;
import com.intellij.sql.dialects.oracle.plus.OrapTokens;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.util.SqlTokenRegistry;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OrapDialect
extends OracleDialect {
    public static final OrapDialect INSTANCE = new OrapDialect();

    public OrapDialect() {
        super("OracleSqlPlus");
    }

    @NotNull
    public String getDisplayName() {
        if ("Oracle SQL*Plus" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/oracle/plus/OrapDialect", "getDisplayName"));
        }
        return "Oracle SQL*Plus";
    }

    @Override
    @Nullable
    public ProblemDescriptor checkIdentifierText(SqlIdentifier o, InspectionManager manager, boolean onTheFly) {
        if (SyntaxTraverser.psiApi().parents((Object)o).filter(Conditions.instanceOf((Class[])new Class[]{SqlQueryExpression.class, IsExternal.class})).first() instanceof IsExternal) {
            return null;
        }
        Pattern regex = Pattern.compile("&\\d+");
        if (regex.matcher(o.getName()).matches()) {
            return null;
        }
        return super.checkIdentifierText(o, manager, onTheFly);
    }

    @Override
    public boolean mayContainExternalPsi() {
        return true;
    }

    @Override
    @NotNull
    public Set<String> getKeywords() {
        Set set = SqlTokenRegistry.getTokens(OrapTokens.class);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/oracle/plus/OrapDialect", "getKeywords"));
        }
        return set;
    }
}

