/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbPresentation;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlCompositeElementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDefinitionImpl
extends SqlCompositeElementImpl
implements SqlDefinition,
ItemPresentation {
    private volatile String myCachedName;

    public SqlDefinitionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlDefinitionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(SqlVisitor visitor) {
        if (this instanceof SqlCreateStatement) {
            visitor.visitSqlCreateStatement((SqlCreateStatement)this);
        } else {
            visitor.visitSqlDefinition((SqlDefinition)this);
        }
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.myCachedName = null;
    }

    @Nullable
    public String getPresentableText() {
        return null;
    }

    @Nullable
    public String getLocationString() {
        return null;
    }

    @Nullable
    public Icon getIcon(boolean unused) {
        return this.getIcon();
    }

    @Nullable
    public Icon getIcon() {
        return DbPresentation.getIcon((DasObject)this);
    }

    @Nullable
    public Icon getIcon(int flags) {
        return this.getIcon();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/sql/psi/impl/SqlDefinitionImpl", "setName"));
        }
        SqlNameElement element = this.getNameElement();
        if (element != null) {
            element.setName(name);
        }
        return this;
    }

    @Override
    @NotNull
    public String getName() {
        String cachedName = this.myCachedName;
        if (cachedName != null) {
            String string = cachedName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlDefinitionImpl", "getName"));
            }
            return string;
        }
        SqlNameElement element = this.getNameElement();
        String name = element == null ? null : element.getName();
        this.myCachedName = (String)ObjectUtils.notNull((Object)name, (Object)SqlImplUtil.NULL_STRING);
        if (this.myCachedName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlDefinitionImpl", "getName"));
        }
        return this.myCachedName;
    }

    protected SqlReferenceExpression findReferenceByType(SqlReferenceElementType type) {
        return (SqlReferenceExpression)this.findChildByType((IElementType)type);
    }

    @Nullable
    public SqlNameElement getNameElement() {
        return (SqlNameElement)this.findChildByClass(SqlReferenceExpression.class);
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.getNameElement();
    }

    @NotNull
    public ObjectKind getKind() {
        SqlNameElement element = this.getNameElement();
        if (element == null) {
            SqlDialectImplUtil.LOG.error(((Object)((Object)this)).getClass() + "/" + this.getNode().getElementType() + "/" + (Object)((Object)SqlImplUtil.getSqlDialectSafe((PsiElement)this)) + "\n" + this.getParent().getText());
            ObjectKind objectKind = SqlDbElementType.ANY;
            if (objectKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlDefinitionImpl", "getKind"));
            }
            return objectKind;
        }
        ObjectKind objectKind = ((SqlReferenceExpression)element).getReferenceElementType().getTargetKind();
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlDefinitionImpl", "getKind"));
        }
        return objectKind;
    }

    @Override
    public ObjectKind getExpectedReferenceTargetType(SqlElement referenceElement) {
        if (this.getNameElement() == referenceElement) {
            return this.getKind();
        }
        return super.getExpectedReferenceTargetType(referenceElement);
    }

    @Override
    public boolean processImplicitContextDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        SqlExpression qualifier;
        SqlNameElement nameElement = this.getNameElement();
        if (lastParent != nameElement && nameElement instanceof SqlReferenceExpression && PsiTreeUtil.isAncestor((PsiElement)this, (PsiElement)lastParent, (boolean)true) && (qualifier = ((SqlReferenceExpression)nameElement).getQualifierExpression()) instanceof SqlReferenceExpression && !SqlImplUtil.processQualifier((SqlReferenceExpression)qualifier, processor, state, place)) {
            return false;
        }
        return super.processImplicitContextDeclarations(processor, state, lastParent, place);
    }

    @Nullable
    public String getComment() {
        return null;
    }

    public DasObject getDbParent() {
        return null;
    }

    @NotNull
    public <C> JBIterable<C> getDbChildren(@NotNull Class<C> clazz, @NotNull ObjectKind kind) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/sql/psi/impl/SqlDefinitionImpl", "getDbChildren"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/psi/impl/SqlDefinitionImpl", "getDbChildren"));
        }
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlDefinitionImpl", "getDbChildren"));
        }
        return jBIterable;
    }
}

