/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl.parser;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.parser.SqlElementFactory;
import com.intellij.sql.psi.impl.parser.SqlParserDefinition;
import org.jetbrains.annotations.NotNull;

public class SqlParserDefinitionBase
extends SqlParserDefinition {
    private final IFileElementType myFileElementType;
    private final SqlElementFactory myElementFactory;

    protected SqlParserDefinitionBase(@NotNull IFileElementType fileElementType, @NotNull SqlElementFactory factory) {
        if (fileElementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileElementType", "com/intellij/sql/psi/impl/parser/SqlParserDefinitionBase", "<init>"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/sql/psi/impl/parser/SqlParserDefinitionBase", "<init>"));
        }
        this.myFileElementType = fileElementType;
        this.myElementFactory = factory;
    }

    public SqlParserDefinitionBase() {
        this(SqlCompositeElementTypes.SQL_FILE, new SqlElementFactory(){

            @Override
            public PsiElement createCompositeElement(ASTNode node) {
                return SqlParserDefinitionBase.createCompositeElementImpl(node);
            }
        });
    }

    @NotNull
    public final SqlElementFactory getElementFactory() {
        SqlElementFactory sqlElementFactory = this.myElementFactory;
        if (sqlElementFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/parser/SqlParserDefinitionBase", "getElementFactory"));
        }
        return sqlElementFactory;
    }

    @NotNull
    public Lexer createLexer(Project project) {
        throw new UnsupportedOperationException("Should not be called directly");
    }

    public PsiParser createParser(Project project) {
        throw new UnsupportedOperationException("Should not be called directly");
    }

    public final IFileElementType getFileNodeType() {
        return this.myFileElementType;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = SqlTokens.WHITE_SPACE_TOKENS;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/parser/SqlParserDefinitionBase", "getWhitespaceTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = SqlTokens.COMMENT_TOKENS;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/parser/SqlParserDefinitionBase", "getCommentTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = SqlTokens.STRING_TOKENS;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/parser/SqlParserDefinitionBase", "getStringLiteralElements"));
        }
        return tokenSet;
    }

    @NotNull
    private static PsiElement createCompositeElementImpl(ASTNode node) {
        ASTNode fileElement = node;
        while (fileElement.getTreeParent() != null) {
            fileElement = fileElement.getTreeParent();
        }
        Object object = fileElement = fileElement instanceof TreeElement ? TreeUtil.getFileElement((TreeElement)((TreeElement)node)) : fileElement;
        if (!(fileElement instanceof FileASTNode)) {
            ASTWrapperPsiElement aSTWrapperPsiElement = new ASTWrapperPsiElement(node);
            if (aSTWrapperPsiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/parser/SqlParserDefinitionBase", "createCompositeElementImpl"));
            }
            return aSTWrapperPsiElement;
        }
        Language fileLanguage = SqlParserDefinitionBase.getLanguage(fileElement);
        Object dialect = fileLanguage instanceof SqlLanguageDialect ? fileLanguage : SqlDialectMappings.getDefaultSqlDialect();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(dialect);
        if (parserDefinition == null) {
            SqlDialectImplUtil.LOG.error("required parser definition not found for: " + dialect.getDisplayName() + ", nodeType: " + node.getElementType() + ", fileType: " + fileElement.getElementType());
            ASTWrapperPsiElement aSTWrapperPsiElement = new ASTWrapperPsiElement(node);
            if (aSTWrapperPsiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/parser/SqlParserDefinitionBase", "createCompositeElementImpl"));
            }
            return aSTWrapperPsiElement;
        }
        PsiElement psiElement = parserDefinition.createElement(node);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/parser/SqlParserDefinitionBase", "createCompositeElementImpl"));
        }
        return psiElement;
    }

    @NotNull
    private static Language getLanguage(@NotNull ASTNode e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/sql/psi/impl/parser/SqlParserDefinitionBase", "getLanguage"));
        }
        PsiElement psi = e.getPsi();
        if (psi instanceof DummyHolder) {
            Language language = psi.getLanguage();
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/parser/SqlParserDefinitionBase", "getLanguage"));
            }
            return language;
        }
        FileViewProvider provider = psi.getContainingFile().getViewProvider();
        if (provider instanceof TemplateLanguageFileViewProvider) {
            Language language = ((TemplateLanguageFileViewProvider)provider).getTemplateDataLanguage();
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/parser/SqlParserDefinitionBase", "getLanguage"));
            }
            return language;
        }
        Language language = e.getElementType().getLanguage();
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/parser/SqlParserDefinitionBase", "getLanguage"));
        }
        return language;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new SqlFileImpl(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }

    @NotNull
    public final PsiElement createElement(ASTNode node) {
        PsiElement psiElement = this.myElementFactory.createCompositeElement(node);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/parser/SqlParserDefinitionBase", "createElement"));
        }
        return psiElement;
    }

    @Override
    public final <T extends PsiElement> T createElement(StubElement<T> stub) {
        return this.myElementFactory.createCompositeElement(stub);
    }
}

