/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.providers;

import com.intellij.jsf.references.JsfResourceNameReference;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.jsp.JspImplicitVariable;
import com.intellij.psi.jsp.el.ELExpression;
import com.intellij.psi.jsp.el.ELLiteralExpression;
import com.intellij.psi.jsp.el.ELSliceExpression;
import com.intellij.psi.jsp.el.ELVariable;
import com.intellij.psi.jsp.el.ElLiteralCustomReferenceProvider;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ElResourceReferenceProvider
implements ElLiteralCustomReferenceProvider {
    public boolean accept(@NotNull ELLiteralExpression expression) {
        String s;
        PsiElement element;
        ELVariable elVariable;
        PsiReference[] references;
        ELExpression from;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/jsf/providers/ElResourceReferenceProvider", "accept"));
        }
        PsiElement parent = expression.getParent();
        return parent instanceof ELSliceExpression && (from = ((ELSliceExpression)parent).getFrom()) instanceof ELVariable && (references = (elVariable = (ELVariable)from).getReferences()).length > 0 && (element = references[0].resolve()) instanceof JspImplicitVariable && "resource".equals(s = ((JspImplicitVariable)element).getName());
    }

    @NotNull
    public PsiReference[] createReferences(@NotNull ELLiteralExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/jsf/providers/ElResourceReferenceProvider", "createReferences"));
        }
        String text = expression.getText();
        if (text != null && text.length() > 1) {
            String textValue = text.substring(1, text.length() - 1);
            if (textValue.contains(":")) {
                PsiReference[] psiReferenceArray = JsfCommonUtils.createLibraryWithResourceReferences(textValue, (PsiElement)expression);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/providers/ElResourceReferenceProvider", "createReferences"));
                }
                return psiReferenceArray;
            }
            if (textValue.contains("/")) {
                PsiReference[] psiReferenceArray = JsfCommonUtils.createTopLevelResourceIdentifierReferences(textValue, (PsiElement)expression);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/providers/ElResourceReferenceProvider", "createReferences"));
                }
                return psiReferenceArray;
            }
            final Module module = ModuleUtil.findModuleForPsiElement((PsiElement)expression);
            if (module != null) {
                JsfResourceNameReference<PsiElement> reference = new JsfResourceNameReference<PsiElement>((PsiElement)expression, TextRange.from((int)1, (int)textValue.length()), false){

                    @Override
                    public Set<PsiDirectory> getLibraries() {
                        return JsfCommonUtils.getTopLevelResourcesDirectories(module);
                    }
                };
                PsiReference[] psiReferenceArray = new PsiReference[]{reference};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/providers/ElResourceReferenceProvider", "createReferences"));
                }
                return psiReferenceArray;
            }
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/providers/ElResourceReferenceProvider", "createReferences"));
        }
        return PsiReference.EMPTY_ARRAY;
    }
}

