/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.toolWindow.tree.nodes;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jsf.model.jam.JsfJamComponent;
import com.intellij.jsf.model.jam.JsfJamModel;
import com.intellij.jsf.model.xml.FacesDomModel;
import com.intellij.jsf.model.xml.component.Component;
import com.intellij.jsf.resources.FacesUIBundle;
import com.intellij.jsf.toolWindow.tree.nodes.AbstractJsfTypeNode;
import com.intellij.jsf.toolWindow.tree.nodes.AnnotatedMembersNode;
import com.intellij.jsf.toolWindow.tree.nodes.JsfDomModelElementNode;
import com.intellij.jsf.toolWindow.tree.nodes.JsfModelElementNode;
import com.intellij.jsf.toolWindow.tree.nodes.JsfModuleNode;
import com.intellij.jsf.toolWindow.tree.nodes.JsfNodeTypes;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.ui.treeStructure.SimpleNode;
import icons.JsfIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ComponentsNode
extends AbstractJsfTypeNode {
    public ComponentsNode(Module module, JsfModuleNode jsfModuleNode, boolean showFromLibraries) {
        super(jsfModuleNode, module, JsfNodeTypes.COMPONENT, showFromLibraries);
        this.setUniformIcon(JsfIcons.Component);
    }

    protected void doUpdate() {
        this.setPlainText(FacesUIBundle.message("components.node.name", new Object[0]));
    }

    @Override
    protected void addAnnotatedNodes(Collection<JsfModelElementNode> nodes) {
        List<JsfJamComponent> jamElements = JsfJamModel.getModel(this.getModule()).getComponents(this.isShowFromLibraries());
        for (JsfJamComponent component : jamElements) {
            nodes.add(new AnnotatedMembersNode<PsiClass>(this.getModule(), component.getPsiElement(), this));
        }
    }

    @Override
    @NotNull
    protected Collection<SimpleNode> getFacesDomModelNodes(@NotNull FacesDomModel domModel) {
        if (domModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domModel", "com/intellij/jsf/toolWindow/tree/nodes/ComponentsNode", "getFacesDomModelNodes"));
        }
        ArrayList<SimpleNode> nodes = new ArrayList<SimpleNode>();
        List<Component> components = domModel.getFacesConfig().getComponents();
        for (final Component component : components) {
            nodes.add(new JsfDomModelElementNode<Component>(this.getProject(), (NodeDescriptor)this, component, JsfIcons.Component){

                @Override
                protected String getActualNodeName() {
                    return component.getComponentClass().getStringValue();
                }

                @Override
                protected String getNodeTextExt() {
                    return component.getComponentType().getStringValue();
                }
            });
        }
        ArrayList<SimpleNode> arrayList = nodes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/toolWindow/tree/nodes/ComponentsNode", "getFacesDomModelNodes"));
        }
        return arrayList;
    }
}

