/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.icp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.URL;
import org.w3c.www.protocol.http.HttpManager;
import org.w3c.www.protocol.http.PropRequestFilterException;
import org.w3c.www.protocol.http.cache.CacheFilter;
import org.w3c.www.protocol.http.icp.ICP;
import org.w3c.www.protocol.http.icp.ICPFilter;
import org.w3c.www.protocol.http.icp.ICPMessage;
import org.w3c.www.protocol.http.icp.ICPProtocolException;
import org.w3c.www.protocol.http.icp.ICPQuery;
import org.w3c.www.protocol.http.icp.ICPReply;
import org.w3c.www.protocol.http.icp.ICPSender;
import org.w3c.www.protocol.http.icp.ICPWaiter;

class ICPReceiver
extends Thread
implements ICP {
    private static final boolean debug = false;
    public static final int DEFAULT_QUEUE_SIZE = 4;
    public static final int DEFAULT_PACKET_SIZE = 512;
    protected int port = -1;
    DatagramSocket socket = null;
    protected int nextid = 1;
    CacheFilter cache = null;
    ICPWaiter[] queue = null;
    protected ICPFilter filter = null;

    protected DatagramSocket getSocket() {
        return this.socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ICPQuery createQuery(URL uRL) {
        int n = -1;
        ICPReceiver iCPReceiver = this;
        synchronized (iCPReceiver) {
            n = this.nextid++;
        }
        return new ICPQuery(n, uRL);
    }

    protected synchronized void addReplyWaiter(ICPWaiter iCPWaiter) {
        if (this.queue != null) {
            for (int i = 0; i < this.queue.length; ++i) {
                if (this.queue[i] != null) continue;
                this.queue[i] = iCPWaiter;
                return;
            }
            ICPWaiter[] iCPWaiterArray = new ICPWaiter[this.queue.length << 1];
            System.arraycopy(this.queue, 0, iCPWaiterArray, 0, this.queue.length);
            iCPWaiterArray[this.queue.length] = iCPWaiter;
            this.queue = iCPWaiterArray;
            return;
        }
        this.queue = new ICPWaiter[4];
        this.queue[0] = iCPWaiter;
    }

    protected synchronized void removeReplyWaiter(ICPWaiter iCPWaiter) {
        if (this.queue != null) {
            for (int i = 0; i < this.queue.length; ++i) {
                if (this.queue[i] != iCPWaiter) continue;
                this.queue[i] = null;
                return;
            }
        }
    }

    protected synchronized void handleReply(ICPReply iCPReply) throws ICPProtocolException {
        int n = iCPReply.getIdentifier();
        for (int i = 0; i < this.queue.length; ++i) {
            if (this.queue[i] == null || this.queue[i].getIdentifier() != n) continue;
            this.queue[i].notifyReply(iCPReply);
            return;
        }
    }

    protected synchronized void handleQuery(ICPQuery iCPQuery) throws ICPProtocolException {
        boolean bl = false;
        ICPReply iCPReply = new ICPReply(iCPQuery.getIdentifier(), bl ? 2 : 3);
        ICPSender iCPSender = this.filter.getSender(iCPQuery.getSenderAddress(), iCPQuery.getSenderPort());
        if (iCPSender != null) {
            iCPSender.send(iCPReply);
        }
    }

    public void run() {
        byte[] byArray = new byte[512];
        while (true) {
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            try {
                this.socket.receive(datagramPacket);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                continue;
            }
            try {
                ICPMessage iCPMessage = ICPMessage.parse(datagramPacket);
                if (iCPMessage instanceof ICPQuery) {
                    this.handleQuery((ICPQuery)iCPMessage);
                    continue;
                }
                this.handleReply((ICPReply)iCPMessage);
                continue;
            }
            catch (ICPProtocolException iCPProtocolException) {
                iCPProtocolException.printStackTrace();
                continue;
            }
            break;
        }
    }

    ICPReceiver(HttpManager httpManager, ICPFilter iCPFilter, int n) throws SocketException, PropRequestFilterException {
        this.setName("ICP-Receiver");
        this.setDaemon(true);
        this.port = n;
        this.filter = iCPFilter;
        this.socket = new DatagramSocket(n);
        try {
            Class<?> clazz = Class.forName("org.w3c.www.protocol.http.cache.CacheFilter");
            this.cache = (CacheFilter)httpManager.getGlobalFilter(clazz);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.cache == null) {
            throw new PropRequestFilterException("no cache filter.");
        }
        this.start();
    }
}

