/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.view;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ExternalSystemViewContributor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleViewContributor
extends ExternalSystemViewContributor {
    private static final Key<?>[] KEYS = new Key[]{GradleSourceSetData.KEY};

    @NotNull
    public ProjectSystemId getSystemId() {
        ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
        if (projectSystemId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/view/GradleViewContributor", "getSystemId"));
        }
        return projectSystemId;
    }

    @NotNull
    public List<Key<?>> getKeys() {
        List<Key<?>> list = Arrays.asList(KEYS);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/view/GradleViewContributor", "getKeys"));
        }
        return list;
    }

    @NotNull
    public List<ExternalSystemNode<?>> createNodes(ExternalProjectsView externalProjectsView, MultiMap<Key<?>, DataNode<?>> dataNodes) {
        SmartList result = new SmartList();
        GradleViewContributor.addCustomSourceSetsNodes(externalProjectsView, dataNodes, result);
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/view/GradleViewContributor", "createNodes"));
        }
        return smartList;
    }

    private static void addCustomSourceSetsNodes(@NotNull ExternalProjectsView externalProjectsView, @NotNull MultiMap<Key<?>, DataNode<?>> dataNodes, @NotNull List<ExternalSystemNode<?>> result) {
        if (externalProjectsView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectsView", "org/jetbrains/plugins/gradle/service/project/view/GradleViewContributor", "addCustomSourceSetsNodes"));
        }
        if (dataNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataNodes", "org/jetbrains/plugins/gradle/service/project/view/GradleViewContributor", "addCustomSourceSetsNodes"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/gradle/service/project/view/GradleViewContributor", "addCustomSourceSetsNodes"));
        }
        Collection sourceSetsDataNodes = dataNodes.get(GradleSourceSetData.KEY);
        if (!sourceSetsDataNodes.isEmpty()) {
            SourceSetsNode sourceSetsNode = new SourceSetsNode(externalProjectsView);
            for (DataNode dataNode : sourceSetsDataNodes) {
                sourceSetsNode.add(new SourceSetNode(externalProjectsView, (DataNode<GradleSourceSetData>)dataNode));
            }
            result.add(sourceSetsNode);
        }
    }

    private static class SourceSetNode
    extends ExternalSystemNode<GradleSourceSetData> {
        public SourceSetNode(ExternalProjectsView externalProjectsView, DataNode<GradleSourceSetData> dataNode) {
            super(externalProjectsView, null, dataNode);
        }

        protected void update(PresentationData presentation) {
            super.update(presentation);
            presentation.setIcon(AllIcons.Modules.SourceFolder);
            GradleSourceSetData data = (GradleSourceSetData)((Object)this.getData());
            if (data != null) {
                this.setNameAndTooltip(this.getName(), null);
            }
        }

        public String getName() {
            GradleSourceSetData data = (GradleSourceSetData)((Object)this.getData());
            return data != null ? StringUtil.substringAfter((String)data.getExternalName(), (String)":") : "";
        }
    }

    @Order(value=9)
    private static class SourceSetsNode
    extends ExternalSystemNode {
        public SourceSetsNode(ExternalProjectsView externalProjectsView) {
            super(externalProjectsView, null, null);
        }

        protected void update(PresentationData presentation) {
            super.update(presentation);
            presentation.setIcon(AllIcons.Nodes.ModuleGroup);
        }

        public String getName() {
            return "Source Sets";
        }
    }
}

