/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve.dsl;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionWeigher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.ResolveResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;

public class GradleCompletionWeigher
extends CompletionWeigher {
    public Comparable weigh(@NotNull LookupElement element, @NotNull CompletionLocation location) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/gradle/service/resolve/dsl/GradleCompletionWeigher", "weigh"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/plugins/gradle/service/resolve/dsl/GradleCompletionWeigher", "weigh"));
        }
        PsiFile containingFile = location.getCompletionParameters().getPosition().getContainingFile();
        if (!(containingFile instanceof GroovyFileBase)) {
            return null;
        }
        if (!FileUtilRt.extensionEquals((String)containingFile.getName(), (String)"gradle")) {
            return null;
        }
        Object o = element.getObject();
        if (o instanceof ResolveResult) {
            PsiElement psiElement = ((ResolveResult)o).getElement();
            PsiFile psiFile = null;
            if (psiElement != null) {
                psiFile = psiElement.getContainingFile();
            }
            if (psiFile == null && psiElement instanceof PsiMember) {
                PsiClass psiClass = ((PsiMember)psiElement).getContainingClass();
                PsiFile psiFile2 = psiFile = psiClass != null ? psiClass.getContainingFile() : null;
            }
            if (psiFile instanceof PsiJavaFile && ((PsiJavaFile)psiFile).getPackageName().startsWith("org.gradle")) {
                return Integer.valueOf(1);
            }
        }
        return Integer.valueOf(-1);
    }
}

