/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web;

import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.converters.PathReferenceConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticPathReferenceConverter
extends PathReferenceConverter {
    private final PathReferenceProvider myStaticProvider = PathReferenceManager.getInstance().createStaticPathReferenceProvider(false);

    public PathReference fromString(@Nullable String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        XmlElement element = context.getReferenceXmlElement();
        return element != null ? this.myStaticProvider.getPathReference(s, (PsiElement)element) : null;
    }

    @NotNull
    public PsiReference[] createReferences(@NotNull PsiElement psiElement, boolean soft) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/javaee/web/StaticPathReferenceConverter", "createReferences"));
        }
        PsiReference[] psiReferenceArray = PathReferenceManager.getReferencesFromProvider((PathReferenceProvider)this.myStaticProvider, (PsiElement)psiElement, (boolean)soft);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/web/StaticPathReferenceConverter", "createReferences"));
        }
        return psiReferenceArray;
    }
}

