/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.web;

import com.intellij.psi.CommonReferenceProviderTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.ReferenceProviderType;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.OrFilter;
import com.intellij.psi.filters.ScopeFilter;
import com.intellij.psi.filters.TextFilter;
import com.intellij.psi.filters.XmlTagFilter;
import com.intellij.psi.filters.position.NamespaceFilter;
import com.intellij.psi.filters.position.ParentElementFilter;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.CustomizableReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.CustomizingReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.WebPathReferenceProvider;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;

public class WebReferenceContributor
extends PsiReferenceContributor {
    public static final ReferenceProviderType DYNAMIC_PATH_REFERENCES_PROVIDER = new ReferenceProviderType("Dynamic Path References Provider");
    public static final ReferenceProviderType PATH_REFERENCES_PROVIDER = new ReferenceProviderType("Path References Provider");

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/j2ee/web/WebReferenceContributor", "registerReferenceProviders"));
        }
        PsiReferenceProvider pathReferenceProvider = PATH_REFERENCES_PROVIDER.getProvider();
        CustomizingReferenceProvider webXmlPathReferenceProvider = new CustomizingReferenceProvider((CustomizableReferenceProvider)pathReferenceProvider);
        webXmlPathReferenceProvider.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, (Object)FileReferenceSet.ABSOLUTE_TOP_LEVEL);
        NamespaceFilter webAppNSFilter = new NamespaceFilter(XmlUtil.WEB_XML_URIS);
        XmlUtil.registerXmlTagReferenceProvider((PsiReferenceRegistrar)registrar, (String[])new String[]{"taglib-location"}, (ElementFilter)webAppNSFilter, (boolean)true, (PsiReferenceProvider)webXmlPathReferenceProvider);
        XmlUtil.registerXmlTagReferenceProvider((PsiReferenceRegistrar)registrar, (String[])new String[]{"small-icon", "large-icon"}, (ElementFilter)webAppNSFilter, (boolean)true, (PsiReferenceProvider)pathReferenceProvider);
        WebPathReferenceProvider dynamicPathReferenceProviderNoEmptyFileReferencesAtEnd = new WebPathReferenceProvider(false, false, true);
        XmlUtil.registerXmlAttributeValueReferenceProvider((PsiReferenceRegistrar)registrar, (String[])new String[]{"value"}, (ElementFilter)new ScopeFilter((ElementFilter)new ParentElementFilter((ElementFilter)new AndFilter((ElementFilter)new NamespaceFilter(XmlUtil.JSTL_CORE_URIS), (ElementFilter)new AndFilter((ElementFilter)XmlTagFilter.INSTANCE, (ElementFilter)new TextFilter("url"))), 2)), (PsiReferenceProvider)dynamicPathReferenceProviderNoEmptyFileReferencesAtEnd);
        XmlUtil.registerXmlAttributeValueReferenceProvider((PsiReferenceRegistrar)registrar, (String[])new String[]{"url"}, (ElementFilter)new ScopeFilter((ElementFilter)new ParentElementFilter((ElementFilter)new AndFilter((ElementFilter)new NamespaceFilter(XmlUtil.JSTL_CORE_URIS), (ElementFilter)new AndFilter((ElementFilter)XmlTagFilter.INSTANCE, (ElementFilter)new OrFilter(new ElementFilter[]{new TextFilter("import"), new TextFilter("redirect")}))), 2)), (PsiReferenceProvider)dynamicPathReferenceProviderNoEmptyFileReferencesAtEnd);
        XmlUtil.registerXmlAttributeValueReferenceProvider((PsiReferenceRegistrar)registrar, (String[])new String[]{"key"}, (ElementFilter)new ScopeFilter((ElementFilter)new ParentElementFilter((ElementFilter)new AndFilter((ElementFilter)new AndFilter((ElementFilter)XmlTagFilter.INSTANCE, (ElementFilter)new TextFilter("message")), (ElementFilter)new OrFilter(new ElementFilter[]{new NamespaceFilter(new String[]{"http://wicket.apache.org/"}), new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                return "wicket".equals(((XmlTag)element).getNamespacePrefix());
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }})), 2)), (PsiReferenceProvider)CommonReferenceProviderTypes.PROPERTIES_FILE_KEY_PROVIDER.getProvider());
    }
}

