/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view;

import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.migration.ApplyJavaeeStyleHandler;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.model.common.ejb.EjbDescriptorVersion;
import com.intellij.javaee.module.view.common.editor.FacetAsVirtualFile;
import com.intellij.javaee.module.view.nodes.JavaeeFacetNodeDescriptor;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import org.jetbrains.annotations.NotNull;

public class ApplyJavaeeStyleAction
extends BaseRefactoringAction {
    protected boolean isAvailableForFile(PsiFile file) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile instanceof FacetAsVirtualFile && ((FacetAsVirtualFile)virtualFile).findFacet() instanceof EjbFacet) {
            return true;
        }
        return virtualFile != null && EjbUtil.getEnterpriseBeansAndInterceptors(virtualFile, file.getProject()).size() > 0;
    }

    protected boolean isEnabledOnDataContext(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        JavaeeFacet facet = (JavaeeFacet)JavaeeFacetNodeDescriptor.FACET_NODE_KEY.getData(dataContext);
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (project == null) {
            return false;
        }
        if (facet instanceof EjbFacet) {
            return true;
        }
        return virtualFile != null && EjbUtil.getEnterpriseBeansAndInterceptors(virtualFile, project).size() > 0;
    }

    public boolean isAvailableInEditorOnly() {
        return false;
    }

    public boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/javaee/module/view/ApplyJavaeeStyleAction", "isEnabledOnElements"));
        }
        return false;
    }

    protected boolean isAvailableForLanguage(Language language) {
        return true;
    }

    public RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/javaee/module/view/ApplyJavaeeStyleAction", "getHandler"));
        }
        return new ApplyJavaeeStyleHandler();
    }

    public void update(AnActionEvent e) {
        JavaeeFacet facet;
        super.update(e);
        Presentation presentation = e.getPresentation();
        presentation.setVisible(presentation.isEnabled());
        if (presentation.isEnabled() && (facet = (JavaeeFacet)JavaeeFacetNodeDescriptor.FACET_NODE_KEY.getData(e.getDataContext())) instanceof EjbFacet) {
            EjbDescriptorVersion ejbDescriptorVersion = EjbUtil.getVersion((EjbFacet)facet);
            if (EjbDescriptorVersion.EJB_VERSION_3_0.compareTo((Enum)ejbDescriptorVersion) <= 0) {
                presentation.setText(J2EEBundle.message((String)"apply.javaee.style.title", (Object[])new Object[0]));
            } else {
                presentation.setText(J2EEBundle.message((String)"apply.javaee.style.title.migrate", (Object[])new Object[0]));
            }
        }
    }
}

