/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.common.editor;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.javaee.module.components.FrameworkElementAsVirtualFileImpl;
import com.intellij.javaee.module.components.FrameworkVirtualFileSystem;
import com.intellij.javaee.module.view.common.editor.FacetAsVirtualFile;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetAsVirtualFileImpl
extends FrameworkElementAsVirtualFileImpl<Facet>
implements FacetAsVirtualFile {
    @NonNls
    public static final String FACET_TYPE = "Facet";
    private final FacetType myFacetType;

    FacetAsVirtualFileImpl(FacetPointer<Facet> facetPointer, FacetType facetType) {
        super(facetPointer, FACET_TYPE, "");
        this.myFacetType = facetType;
    }

    @Override
    public String getPresentableName() {
        return this.myFacetType.getPresentableName() + " '" + this.getFacetName() + "'";
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return this.myFacetType.getIcon();
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getFacetName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/view/common/editor/FacetAsVirtualFileImpl", "getName"));
        }
        return string;
    }

    @Nullable
    public static FacetAsVirtualFileImpl fileByPath(Facet facet) {
        String path = FacetAsVirtualFileImpl.getPath(facet, FACET_TYPE, "");
        return (FacetAsVirtualFileImpl)FrameworkVirtualFileSystem.getJ2EEInstance().findFileByPath(path);
    }

    public Facet getWrappedObject(Project project) {
        return this.findFacet();
    }
}

