/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.ejb.editor;

import com.intellij.facet.Facet;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.ejb.EjbModuleUtil;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.model.common.ejb.Interceptor;
import com.intellij.javaee.model.common.ejb.InterceptorSet;
import com.intellij.javaee.module.components.FrameworkElementAsVirtualFileImpl;
import com.intellij.javaee.module.components.FrameworkVirtualFileSystem;
import com.intellij.javaee.module.view.ejb.editor.InterceptorAsVirtualFile;
import com.intellij.openapi.project.Project;
import com.intellij.util.JavaeeIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class InterceptorAsVirtualFileImpl
extends FrameworkElementAsVirtualFileImpl<EjbFacet>
implements InterceptorAsVirtualFile {
    @NonNls
    public static final String INTERCEPTOR_TYPE = "EjbInterceptor";

    InterceptorAsVirtualFileImpl(FacetPointer<EjbFacet> facetPointer, String elementName) {
        super(facetPointer, INTERCEPTOR_TYPE, elementName);
    }

    @Nullable
    public Interceptor findElement(Project project) {
        JavaeeFacet facet = (JavaeeFacet)this.findFacet();
        if (!(facet instanceof EjbFacet)) {
            return null;
        }
        InterceptorSet interceptorSet = ((EjbFacet)facet).getMergedRoot().getInterceptors();
        return EjbUtil.findInterceptorByClassName(interceptorSet, this.getElementName());
    }

    @Override
    public String getPresentableName() {
        return J2EEBundle.message((String)"ejb.interceptor.type", (Object[])new Object[0]) + " '" + this.getElementName() + "'";
    }

    @Override
    public Icon getIcon() {
        return JavaeeIcons.EJB_INTERCEPTOR_CLASS_ICON;
    }

    @Nullable
    public static InterceptorAsVirtualFileImpl findFile(Interceptor interceptor) {
        if (!interceptor.isValid()) {
            return null;
        }
        EjbFacet ejbFacet = EjbModuleUtil.getEjbFacet((JavaeeModelElement)interceptor);
        if (ejbFacet == null) {
            return null;
        }
        String name = interceptor.getInterceptorClass().getStringValue();
        String path = InterceptorAsVirtualFileImpl.getPath((Facet)ejbFacet, INTERCEPTOR_TYPE, name);
        return (InterceptorAsVirtualFileImpl)FrameworkVirtualFileSystem.getJ2EEInstance().findFileByPath(path);
    }
}

