/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.ejb.permissions;

import com.intellij.ide.TypePresentationService;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.model.xml.DescriptionOwner;
import com.intellij.javaee.model.xml.SecurityRole;
import com.intellij.javaee.model.xml.ejb.AssemblyDescriptor;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameHelper;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.xml.DomUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditSecurityRoleDialog
extends DialogWrapper {
    private JPanel myPanel;
    private JTextArea myDescription;
    private JTextField myRoleName;
    private final AssemblyDescriptor myDescriptor;
    private final SecurityRole myRole;

    protected EditSecurityRoleDialog(@NotNull AssemblyDescriptor descriptor, @Nullable SecurityRole role, String title) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/javaee/module/view/ejb/permissions/EditSecurityRoleDialog", "<init>"));
        }
        super(descriptor.getManager().getProject(), true);
        this.myDescriptor = descriptor;
        this.myRole = role;
        this.$$$setupUI$$$();
        this.setTitle(title);
        if (role != null) {
            this.myRoleName.setText((String)role.getRoleName().getValue());
            this.myDescription.setText(JavaeeUtil.getDescription((DescriptionOwner)role));
        }
        this.init();
    }

    protected void doOKAction() {
        final String name = this.myRoleName.getText();
        PsiNameHelper helper = PsiNameHelper.getInstance((Project)this.myDescriptor.getPsiManager().getProject());
        if (!helper.isIdentifier(name)) {
            Messages.showErrorDialog((String)J2EEBundle.message((String)"error.message.name.should.be.identifier", (Object[])new Object[0]), (String)J2EEBundle.message((String)"message.title.error", (Object[])new Object[0]));
            return;
        }
        HashSet set = new HashSet(this.myDescriptor.getSecurityRoles());
        set.remove(this.myRole);
        if (DomUtil.findByName(set, (String)name) != null) {
            Messages.showErrorDialog((String)J2EEBundle.message((String)"error.message.0.name.should.be.unique", (Object[])new Object[]{TypePresentationService.getService().getTypePresentableName(SecurityRole.class)}), (String)J2EEBundle.message((String)"message.title.error", (Object[])new Object[0]));
            return;
        }
        super.doOKAction();
        new WriteCommandAction(this.myDescriptor.getManager().getProject(), new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javaee/module/view/ejb/permissions/EditSecurityRoleDialog$1", "run"));
                }
                SecurityRole role = EditSecurityRoleDialog.this.myRole != null ? EditSecurityRoleDialog.this.myRole : EditSecurityRoleDialog.this.myDescriptor.addSecurityRole();
                role.getRoleName().setValue((Object)name);
                JavaeeUtil.setDescription((DescriptionOwner)role, EditSecurityRoleDialog.this.myDescription.getText());
            }
        }.execute();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myRoleName;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextArea jTextArea;
        JTextField jTextField;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.edit.security.role.name"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/J2EEBundle").getString("label.edit.security.role.description"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myRoleName = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myDescription = jTextArea = new JTextArea();
        jTextArea.setRows(3);
        jTextArea.setColumns(50);
        jBScrollPane.setViewportView(jTextArea);
        jLabel.setLabelFor(jTextField);
        jLabel2.setLabelFor(jTextArea);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

