/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui;

import com.intellij.ProjectTopics;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.jam.view.tree.JamAbstractTreeBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.Function;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import org.jetbrains.annotations.NotNull;

public abstract class FrameworkToolWindowViewBase
extends SimpleToolWindowPanel
implements Disposable {
    protected final Project myProject;
    protected final JamAbstractTreeBuilder myBuilder;
    protected final Tree myTree = new DnDAwareTree();

    public FrameworkToolWindowViewBase(Project project, FrameworkViewTreeStructureProvider treeStructureProvider) {
        super(true, true);
        this.myProject = project;
        this.myBuilder = new JamAbstractTreeBuilder((JTree)this.myTree, treeStructureProvider.createTreeStructure(project));
        HintUpdateSupply.installDataContextHintUpdateSupply((JComponent)this.myTree);
        this.initListeners(this.myProject.getMessageBus().connect((Disposable)this));
        Disposer.register((Disposable)this.myProject, (Disposable)this);
    }

    protected void initComponents() {
        this.myBuilder.init();
        Disposer.register((Disposable)this, (Disposable)this.myBuilder);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.myTree);
        TreeUtil.installActions((JTree)this.myTree);
        EditSourceOnDoubleClickHandler.install((JTree)this.myTree);
        new TreeSpeedSearch((JTree)this.myTree);
        this.setContent(ScrollPaneFactory.createScrollPane((Component)this.myTree));
    }

    protected void updateTree() {
        if (this.myBuilder.isDisposed()) {
            return;
        }
        this.myBuilder.queueUpdate();
    }

    public void dispose() {
    }

    private void initListeners(MessageBusConnection connection) {
        connection.subscribe(PsiModificationTracker.TOPIC, (Object)new PsiModificationTracker.Listener(){

            public void modificationCountChanged() {
                FrameworkToolWindowViewBase.this.updateTree();
            }
        });
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                FrameworkToolWindowViewBase.this.updateTree();
            }
        });
        connection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void moduleAdded(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/ui/FrameworkToolWindowViewBase$3", "moduleAdded"));
                }
                if (module == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/javaee/ui/FrameworkToolWindowViewBase$3", "moduleAdded"));
                }
                FrameworkToolWindowViewBase.this.updateTree();
            }

            public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/ui/FrameworkToolWindowViewBase$3", "moduleRemoved"));
                }
                if (module == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/javaee/ui/FrameworkToolWindowViewBase$3", "moduleRemoved"));
                }
                FrameworkToolWindowViewBase.this.updateTree();
            }

            public void modulesRenamed(@NotNull Project project, @NotNull List<Module> modules, @NotNull Function<Module, String> oldNameProvider) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/ui/FrameworkToolWindowViewBase$3", "modulesRenamed"));
                }
                if (modules == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/javaee/ui/FrameworkToolWindowViewBase$3", "modulesRenamed"));
                }
                if (oldNameProvider == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNameProvider", "com/intellij/javaee/ui/FrameworkToolWindowViewBase$3", "modulesRenamed"));
                }
                FrameworkToolWindowViewBase.this.updateTree();
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/javaee/ui/FrameworkToolWindowViewBase$4", "after"));
                }
                FrameworkToolWindowViewBase.this.updateTree();
            }
        });
        FileStatusManager.getInstance((Project)this.myProject).addFileStatusListener(new FileStatusListener(){

            public void fileStatusesChanged() {
                FrameworkToolWindowViewBase.this.updateTree();
            }

            public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
                if (virtualFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/javaee/ui/FrameworkToolWindowViewBase$5", "fileStatusChanged"));
                }
                FrameworkToolWindowViewBase.this.updateTree();
            }
        }, (Disposable)this);
        CopyPasteManager.getInstance().addContentChangedListener(new CopyPasteManager.ContentChangedListener(){

            public void contentChanged(Transferable oldTransferable, Transferable newTransferable) {
                FrameworkToolWindowViewBase.this.updateTree();
            }
        }, (Disposable)this);
    }

    public void setupToolWindow(ToolWindowEx toolWindow) {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        this.addTitleActions(actions);
        toolWindow.setTitleActions(actions.toArray(new AnAction[actions.size()]));
        DefaultActionGroup group = new DefaultActionGroup();
        this.addGearActions(group);
        if (group.getChildrenCount() > 0) {
            toolWindow.setAdditionalGearActions((ActionGroup)group);
        }
    }

    protected void addTitleActions(List<AnAction> actions) {
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        actions.add(actionsManager.createExpandAllHeaderAction((JTree)this.myTree));
        actions.add(actionsManager.createCollapseAllHeaderAction((JTree)this.myTree));
    }

    protected void addGearActions(DefaultActionGroup group) {
    }

    protected static abstract class FrameworkViewTreeStructureProvider {
        protected FrameworkViewTreeStructureProvider() {
        }

        public abstract SimpleTreeStructure createTreeStructure(@NotNull Project var1);
    }
}

