/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.javaee.JavaeePersistenceDescriptorsConstants;
import com.intellij.jpa.JpaDataSourceDetectorBase;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class JpaDataSourceDetector
extends JpaDataSourceDetectorBase<JpaFacet> {
    private final Map<String, PairConsumer<DataSourceDetector.Builder, Properties>> myProviders = ContainerUtil.newLinkedHashMap();

    @NotNull
    public static PairConsumer<DataSourceDetector.Builder, Properties> providerHibernate() {
        PairConsumer<DataSourceDetector.Builder, Properties> pairConsumer = JpaDataSourceDetector.provider("connection.url, hibernate.connection.url", "connection.username, hibernate.connection.username", "connection.url, hibernate.connection.url", "connection.driver_class, hibernate.connection.driver_class");
        if (pairConsumer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/JpaDataSourceDetector", "providerHibernate"));
        }
        return pairConsumer;
    }

    public JpaDataSourceDetector() {
        super(JpaFacet.ID);
        this.myProviders.put("Hibernate", JpaDataSourceDetector.providerHibernate());
        this.myProviders.put("EclipseLink", JpaDataSourceDetector.provider("eclipselink.jdbc.url", "eclipselink.jdbc.user", "eclipselink.jdbc.password", "eclipselink.jdbc.driver"));
        this.myProviders.put("glassfish", JpaDataSourceDetector.provider("jdbc.connection.string", "jdbc.user", "jdbc.password", "jdbc.driver"));
        this.myProviders.put("OpenJPA", JpaDataSourceDetector.provider("openjpa.ConnectionURL", "openjpa.ConnectionUserName", "openjpa.ConnectionPassword", "openjpa.ConnectionDriverName"));
        this.myProviders.put("TopLink", JpaDataSourceDetector.provider("toplink.jdbc.url", "toplink.jdbc.user", "toplink.jdbc.password", "toplink.jdbc.driver"));
    }

    @Override
    protected Map<String, PairConsumer<DataSourceDetector.Builder, Properties>> getProviders() {
        return this.myProviders;
    }

    public boolean isRelevantFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jpa/JpaDataSourceDetector", "isRelevantFile"));
        }
        VirtualFile virtualFile = file.getVirtualFile();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)file.getProject()).getFileIndex();
        return virtualFile != null && JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA.getFileName().equals(virtualFile.getName()) && !fileIndex.isInTestSourceContent(virtualFile);
    }
}

