/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.jpa.ql.JpqlLanguage;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutor;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaQueryLanguageSubstitutor
extends LanguageSubstitutor {
    @NotNull
    private static Pair<Language, Integer> SQL_LANGUAGE = Pair.create(null, (Object)0);

    @Nullable
    private static Language getSqlLanguage() {
        Collection languages = Language.getRegisteredLanguages();
        if (languages.size() == ((Integer)JpaQueryLanguageSubstitutor.SQL_LANGUAGE.second).intValue()) {
            return (Language)JpaQueryLanguageSubstitutor.SQL_LANGUAGE.first;
        }
        Language sql = Language.findLanguageByID((String)"SQL");
        SQL_LANGUAGE = Pair.create((Object)(sql == null ? PlainTextLanguage.INSTANCE : sql), (Object)languages.size());
        return (Language)JpaQueryLanguageSubstitutor.SQL_LANGUAGE.first;
    }

    @Nullable
    private static XmlTag getInjectionHost(VirtualFile file) {
        PsiLanguageInjectionHost host = InjectedLanguageUtil.findInjectionHost((VirtualFile)file);
        return host instanceof XmlElement ? (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)host, XmlTag.class) : null;
    }

    public Language getLanguage(@NotNull VirtualFile file, @NotNull Project project) {
        XmlTag parentTag;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jpa/JpaQueryLanguageSubstitutor", "getLanguage"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jpa/JpaQueryLanguageSubstitutor", "getLanguage"));
        }
        XmlTag host = JpaQueryLanguageSubstitutor.getInjectionHost(file);
        if (host != null && (parentTag = host.getParentTag()) != null && "named-native-query".equals(parentTag.getName())) {
            Language sqlLanguage = JpaQueryLanguageSubstitutor.getSqlLanguage();
            return sqlLanguage != null ? LanguageSubstitutors.INSTANCE.substituteLanguage(sqlLanguage, file, project) : null;
        }
        VirtualFile realFile = file instanceof VirtualFileWindow ? ((VirtualFileWindow)file).getDelegate() : file;
        VirtualFile virtualFile = realFile = realFile instanceof LightVirtualFile ? (VirtualFile)ObjectUtils.notNull((Object)((LightVirtualFile)realFile).getOriginalFile(), (Object)realFile) : realFile;
        return JpaUtil.isHibernateProvider(project, realFile) ? JpqlLanguage.HQL : (JpaUtil.isEclipseLinkProvider(project, realFile) ? JpqlLanguage.EQL : null);
    }

    public static final class Ejbql
    extends LanguageSubstitutor {
        public Language getLanguage(@NotNull VirtualFile file, @NotNull Project project) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jpa/JpaQueryLanguageSubstitutor$Ejbql", "getLanguage"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jpa/JpaQueryLanguageSubstitutor$Ejbql", "getLanguage"));
            }
            XmlTag host = JpaQueryLanguageSubstitutor.getInjectionHost(file);
            if (host == null) {
                return null;
            }
            if ("http://java.sun.com/xml/ns/javaee".equals(host.getNamespace())) {
                return JpqlLanguage.JPQL;
            }
            return null;
        }
    }
}

