/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.actions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.ide.DataManager;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.util.UnitSettingMapConfigurable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.JBColor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignDataSourcesAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/jpa/actions/AssignDataSourcesAction", "update"));
        }
        PersistenceFacet facet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(e.getDataContext());
        boolean enabled = facet != null;
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/jpa/actions/AssignDataSourcesAction", "actionPerformed"));
        }
        PersistenceFacet facet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(e.getDataContext());
        if (facet == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)facet.getModule().getProject()).commitAllDocuments();
        AssignDataSourcesAction.showUnitDataSourceMappingDialog(facet);
    }

    public static void showUnitDataSourceMappingDialog(@NotNull PersistenceFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/jpa/actions/AssignDataSourcesAction", "showUnitDataSourceMappingDialog"));
        }
        ShowSettingsUtil.getInstance().editConfigurable(facet.getModule().getProject(), (Configurable)new MyComponent(facet));
    }

    private static class MyComponent
    extends UnitSettingMapConfigurable<PersistenceFacet, DatabaseSystem>
    implements DataProvider {
        private final DbPsiFacade myManager;
        private final DatabaseSystem myMissingValue = new LocalDataSource("Missing data source", null, null, null, null);
        private final ComboBoxTableRenderer<DatabaseSystem> myCombo;

        public MyComponent(PersistenceFacet facet) {
            super(facet);
            this.myManager = DbPsiFacade.getInstance((Project)this.myFacet.getModule().getProject());
            DataManager.registerDataProvider((JComponent)this.getComponent(), (DataProvider)this);
            ArrayList copy = ContainerUtil.newArrayList((Iterable)DbPsiFacade.getInstance((Project)this.myFacet.getModule().getProject()).getDataSources());
            Collections.sort(copy, (o1, o2) -> StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName()));
            LocalDataSource nullValue = new LocalDataSource("", null, null, null, null);
            copy.add(0, nullValue);
            this.myCombo = new ComboBoxTableRenderer<DatabaseSystem>(copy.toArray(new DatabaseSystem[copy.size()]), (DatabaseSystem)nullValue){
                final /* synthetic */ DatabaseSystem val$nullValue;
                {
                    this.val$nullValue = databaseSystem;
                    super((Object[])x0);
                }

                public boolean isCellEditable(EventObject event) {
                    return !(event instanceof MouseEvent) || ((MouseEvent)event).getClickCount() >= 1;
                }

                protected String getTextFor(@NotNull DatabaseSystem value) {
                    if (value == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/jpa/actions/AssignDataSourcesAction$MyComponent$1", "getTextFor"));
                    }
                    return value == this.val$nullValue ? "No data source" : value.getName();
                }

                protected Icon getIconFor(@NotNull DatabaseSystem value) {
                    if (value == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/jpa/actions/AssignDataSourcesAction$MyComponent$1", "getIconFor"));
                    }
                    return value instanceof DbDataSource ? ((DbDataSource)value).getIcon() : EmptyIcon.ICON_16;
                }

                protected void customizeComponent(DatabaseSystem value, JTable table, boolean isSelected) {
                    super.customizeComponent((Object)value, table, isSelected);
                    if (value == myMissingValue) {
                        this.setForeground((Color)JBColor.RED);
                    } else if (!isSelected && !(value instanceof DbDataSource)) {
                        this.setForeground(UIUtil.getComboBoxDisabledForeground());
                    }
                }
            };
            this.myCombo.setFont(UIUtil.getLabelFont());
        }

        @NotNull
        protected ComboBoxTableRenderer<DatabaseSystem> getComboBoxTableRenderer() {
            ComboBoxTableRenderer<DatabaseSystem> comboBoxTableRenderer = this.myCombo;
            if (comboBoxTableRenderer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/actions/AssignDataSourcesAction$MyComponent", "getComboBoxTableRenderer"));
            }
            return comboBoxTableRenderer;
        }

        public void apply() throws ConfigurationException {
            super.apply();
            Project project = this.myFacet.getModule().getProject();
            DomElementAnnotationsManager.getInstance((Project)project).dropAnnotationsCache();
            DaemonCodeAnalyzer.getInstance((Project)project).restart();
        }

        @NotNull
        protected String getValueColumnName() {
            if ("Data Source" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/actions/AssignDataSourcesAction$MyComponent", "getValueColumnName"));
            }
            return "Data Source";
        }

        @Nullable
        protected DatabaseSystem getSettingValue(PersistencePackage unit) {
            String id = this.myFacet.getDataSourceId(unit);
            DbDataSource result = this.myManager.findDataSource(id);
            return result == null && id != null ? this.myMissingValue : result;
        }

        protected void setSettingValue(PersistencePackage unit, DatabaseSystem value) {
            this.myFacet.setDataSourceId(unit, value instanceof DbDataSource ? value.getUniqueId() : null);
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                DatabaseSystem value = (DatabaseSystem)this.getSelectedValue();
                return ObjectUtils.tryCast((Object)value, DbDataSource.class);
            }
            if (DatabaseDataKeys.DB_PSI_FACADE.is(dataId)) {
                return this.myManager;
            }
            return null;
        }

        @Nls
        public String getDisplayName() {
            return JpaHighlightingMessages.message("fix.edit.unit.datasource.name", new Object[0]);
        }

        @Nullable
        public String getHelpTopic() {
            return null;
        }
    }
}

