/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.module.view.web.editor.ServletAsVirtualFile;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.ex.FakeFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ultimate.PluginVerifier;
import com.intellij.ultimate.UltimateVerifier;
import org.jetbrains.annotations.NotNull;

public class WebApplicationFileTypeFactory
extends FileTypeFactory {
    private final FakeFileType myServletFileType;

    public WebApplicationFileTypeFactory(UltimateVerifier verifier) {
        PluginVerifier.verifyUltimatePlugin(verifier);
        this.myServletFileType = new FakeFileType(){

            @NotNull
            public String getName() {
                if ("Servlet" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/WebApplicationFileTypeFactory$1", "getName"));
                }
                return "Servlet";
            }

            @NotNull
            public String getDescription() {
                String string = J2EEBundle.message((String)"servlet.fake.file.type.description", (Object[])new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/WebApplicationFileTypeFactory$1", "getDescription"));
                }
                return string;
            }

            public boolean isMyFileType(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/module/WebApplicationFileTypeFactory$1", "isMyFileType"));
                }
                return file instanceof ServletAsVirtualFile;
            }
        };
    }

    public void createFileTypes(@NotNull FileTypeConsumer consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/openapi/module/WebApplicationFileTypeFactory", "createFileTypes"));
        }
        consumer.consume((FileType)this.myServletFileType, "");
    }
}

