/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.ide.IconProvider;
import com.intellij.ide.IconUtilEx;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.util.JavaeeIcons;
import com.intellij.util.PlatformIcons;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebIconProvider
extends IconProvider
implements DumbAware {
    @Nullable
    public Icon getIcon(@NotNull PsiElement element, int flags) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/module/WebIconProvider", "getIcon"));
        }
        if (element instanceof PsiDirectory) {
            PsiDirectory psiDirectory = (PsiDirectory)element;
            if (WebIconProvider.isWebRoot(psiDirectory.getVirtualFile(), psiDirectory.getProject())) {
                return JavaeeIcons.WEB_FOLDER_CLOSED;
            }
        } else if (element instanceof WebDirectoryElement) {
            WebDirectoryElement webDirectoryElement = (WebDirectoryElement)element;
            PsiFile file = webDirectoryElement.getOriginalFile();
            return webDirectoryElement.isDirectory() || file == null ? PlatformIcons.DIRECTORY_CLOSED_ICON : IconUtilEx.getIcon((Object)file, (int)flags, (Project)element.getProject());
        }
        return null;
    }

    private static boolean isWebRoot(@NotNull VirtualFile file, Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/module/WebIconProvider", "isWebRoot"));
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module module = projectFileIndex.getModuleForFile(file);
        if (module == null || module.isDisposed()) {
            return false;
        }
        Collection webFacets = WebFacet.getInstances((Module)module);
        for (WebFacet webFacet : webFacets) {
            List webRoots = webFacet.getWebRoots();
            for (WebRoot webRoot : webRoots) {
                if (!file.equals(webRoot.getFile())) continue;
                return true;
            }
        }
        return false;
    }
}

