/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.perspectives.diagrams.beans;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.perspectives.diagrams.beans.SpringElementWrapper;
import com.intellij.spring.perspectives.diagrams.beans.SpringElementWrapperBase;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanClassWrapper
extends SpringElementWrapperBase<PsiClass> {
    private static final String PSI_CLASS = "mappedClass";

    public SpringBeanClassWrapper(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/perspectives/diagrams/beans/SpringBeanClassWrapper", "<init>"));
        }
        super(psiClass);
    }

    @Override
    public Icon getIcon() {
        return ((PsiClass)this.getWrapped()).getIcon(0);
    }

    @Override
    public Module getModule() {
        return ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)this.getWrapped()));
    }

    @Override
    public String getName() {
        return ((PsiClass)this.getWrapped()).getName();
    }

    @Override
    public CommonSpringModel getProcessingSpringModel(boolean localModel) {
        PsiClass psiClass = (PsiClass)this.getWrapped();
        return SpringModelUtils.getInstance().getPsiClassSpringModel(psiClass);
    }

    @Override
    public String getFqn() {
        return "mappedClass=" + ((PsiClass)this.getWrapped()).getQualifiedName();
    }

    @Nullable
    public static SpringElementWrapper resolveElementByFQN(String fqn, Project project) {
        JavaPsiFacade facade;
        PsiClass psiClass;
        String psiClassFqn = SpringBeanClassWrapper.split(fqn).get(PSI_CLASS);
        if (!StringUtil.isEmptyOrSpaces((String)psiClassFqn) && (psiClass = (facade = JavaPsiFacade.getInstance((Project)project)).findClass(psiClassFqn, GlobalSearchScope.allScope((Project)project))) != null) {
            return new SpringBeanClassWrapper(psiClass);
        }
        return null;
    }
}

