/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public interface RefactoringQuickFix
extends LocalQuickFix {
    @Override
    default public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public RefactoringActionHandler getHandler();

    default public PsiElement getElementToRefactor(PsiElement element) {
        PsiElement parent = element.getParent();
        return parent instanceof PsiNamedElement ? parent : element;
    }

    default public void doFix(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/RefactoringQuickFix", "doFix"));
        }
        PsiElement elementToRefactor = this.getElementToRefactor(element);
        if (elementToRefactor == null) {
            return;
        }
        Consumer consumer = dataContext -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/RefactoringQuickFix", "lambda$doFix$0"));
            }
            dataContext = this.enhanceDataContext((DataContext)dataContext);
            RefactoringActionHandler handler = this.getHandler();
            handler.invoke(element.getProject(), new PsiElement[]{elementToRefactor}, (DataContext)dataContext);
        };
        DataManager.getInstance().getDataContextFromFocus().doWhenDone((Consumer<DataContext>)consumer);
    }

    @Override
    default public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/RefactoringQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/RefactoringQuickFix", "applyFix"));
        }
        this.doFix(descriptor.getPsiElement());
    }

    @NotNull
    default public DataContext enhanceDataContext(@NonNls DataContext context) {
        DataContext dataContext = context;
        if (dataContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RefactoringQuickFix", "enhanceDataContext"));
        }
        return dataContext;
    }
}

