/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.compiler.ModuleSourceSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Couple;
import com.intellij.util.Chunk;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;

public final class ModuleCompilerUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.ModuleCompilerUtil");

    private ModuleCompilerUtil() {
    }

    @NotNull
    public static Module[] getDependencies(Module module) {
        Module[] moduleArray = ModuleRootManager.getInstance(module).getDependencies();
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/ModuleCompilerUtil", "getDependencies"));
        }
        return moduleArray;
    }

    @NotNull
    private static Graph<Module> createModuleGraph(final @NotNull Module[] modules) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/compiler/ModuleCompilerUtil", "createModuleGraph"));
        }
        Graph graph = GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new InboundSemiGraph<Module>(){

            public Collection<Module> getNodes() {
                return Arrays.asList(modules);
            }

            public Iterator<Module> getIn(Module module) {
                return Arrays.asList(ModuleCompilerUtil.getDependencies(module)).iterator();
            }
        }));
        if (graph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/ModuleCompilerUtil", "createModuleGraph"));
        }
        return graph;
    }

    @NotNull
    public static List<Chunk<Module>> getSortedModuleChunks(@NotNull Project project, @NotNull List<Module> modules) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/ModuleCompilerUtil", "getSortedModuleChunks"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/compiler/ModuleCompilerUtil", "getSortedModuleChunks"));
        }
        Module[] allModules = ModuleManager.getInstance(project).getModules();
        List<Chunk<Module>> chunks = ModuleCompilerUtil.getSortedChunks(ModuleCompilerUtil.createModuleGraph(allModules));
        HashSet<Module> modulesSet = new HashSet<Module>(modules);
        chunks.removeIf(chunk -> !ContainerUtil.intersects((Collection)chunk.getNodes(), (Collection)modulesSet));
        List<Chunk<Module>> list = chunks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/ModuleCompilerUtil", "getSortedModuleChunks"));
        }
        return list;
    }

    @NotNull
    private static <Node> List<Chunk<Node>> getSortedChunks(@NotNull Graph<Node> graph) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/compiler/ModuleCompilerUtil", "getSortedChunks"));
        }
        Graph<Chunk<Node>> chunkGraph = ModuleCompilerUtil.toChunkGraph(graph);
        ArrayList<Chunk<Node>> chunks = new ArrayList<Chunk<Node>>(chunkGraph.getNodes().size());
        for (Chunk chunk : chunkGraph.getNodes()) {
            chunks.add(chunk);
        }
        DFSTBuilder builder = new DFSTBuilder(chunkGraph);
        if (!builder.isAcyclic()) {
            LOG.error("Acyclic graph expected");
            if (null == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/ModuleCompilerUtil", "getSortedChunks"));
            }
            return null;
        }
        Collections.sort(chunks, builder.comparator());
        ArrayList<Chunk<Node>> arrayList = chunks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/ModuleCompilerUtil", "getSortedChunks"));
        }
        return arrayList;
    }

    @NotNull
    public static <Node> Graph<Chunk<Node>> toChunkGraph(@NotNull Graph<Node> graph) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/compiler/ModuleCompilerUtil", "toChunkGraph"));
        }
        Graph<Chunk<Node>> graph2 = GraphAlgorithms.getInstance().computeSCCGraph(graph);
        if (graph2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/ModuleCompilerUtil", "toChunkGraph"));
        }
        return graph2;
    }

    public static void sortModules(Project project, List<Module> modules) {
        ApplicationManager.getApplication().runReadAction(() -> {
            Comparator<Module> comparator = ModuleManager.getInstance(project).moduleDependencyComparator();
            Collections.sort(modules, comparator);
        });
    }

    @NotNull
    private static <T extends ModuleRootModel> Graph<T> createGraphGenerator(final @NotNull Map<Module, T> models) {
        if (models == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/intellij/compiler/ModuleCompilerUtil", "createGraphGenerator"));
        }
        Graph graph = GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new InboundSemiGraph<T>(){

            public Collection<T> getNodes() {
                return models.values();
            }

            public Iterator<T> getIn(ModuleRootModel model) {
                ArrayList dependencies = new ArrayList();
                model.orderEntries().compileOnly().forEachModule((Processor<Module>)((Processor)module -> {
                    if (models == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/intellij/compiler/ModuleCompilerUtil$2", "lambda$getIn$0"));
                    }
                    ModuleRootModel depModel = (ModuleRootModel)models.get(module);
                    if (depModel != null) {
                        dependencies.add(depModel);
                    }
                    return true;
                }));
                return dependencies.iterator();
            }
        }));
        if (graph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/ModuleCompilerUtil", "createGraphGenerator"));
        }
        return graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Couple<Module> addingDependencyFormsCircularity(@NotNull Module currentModule, @NotNull Module toDependOn) {
        if (currentModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentModule", "com/intellij/compiler/ModuleCompilerUtil", "addingDependencyFormsCircularity"));
        }
        if (toDependOn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toDependOn", "com/intellij/compiler/ModuleCompilerUtil", "addingDependencyFormsCircularity"));
        }
        assert (currentModule != toDependOn);
        LinkedHashMap<Module, ModifiableRootModel> models = new LinkedHashMap<Module, ModifiableRootModel>();
        Project project = currentModule.getProject();
        for (Module module : ModuleManager.getInstance(project).getModules()) {
            ModifiableRootModel modifiableRootModel = ModuleRootManager.getInstance(module).getModifiableModel();
            models.put(module, modifiableRootModel);
        }
        ModifiableRootModel currentModel = (ModifiableRootModel)models.get(currentModule);
        ModifiableRootModel toDependOnModel = (ModifiableRootModel)models.get(toDependOn);
        Collection nodesBefore = ModuleCompilerUtil.buildChunks(models);
        for (Chunk chunk : nodesBefore) {
            if (!chunk.containsNode((Object)toDependOnModel) || !chunk.containsNode((Object)currentModel)) continue;
            return null;
        }
        try {
            currentModel.addModuleOrderEntry(toDependOn);
            Collection nodesAfter = ModuleCompilerUtil.buildChunks(models);
            for (Chunk chunk : nodesAfter) {
                if (!chunk.containsNode((Object)toDependOnModel) || !chunk.containsNode((Object)currentModel)) continue;
                List nodes = ContainerUtil.collect(chunk.getNodes().iterator());
                nodes.sort(Comparator.comparing(m -> m.getModule().getName()));
                Couple couple = Couple.of((Object)((ModifiableRootModel)nodes.get(0)).getModule(), (Object)((ModifiableRootModel)nodes.get(1)).getModule());
                return couple;
            }
        }
        finally {
            for (ModifiableRootModel model : models.values()) {
                model.dispose();
            }
        }
        return null;
    }

    @NotNull
    private static <T extends ModuleRootModel> Collection<Chunk<T>> buildChunks(@NotNull Map<Module, T> models) {
        if (models == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/intellij/compiler/ModuleCompilerUtil", "buildChunks"));
        }
        Collection collection = ModuleCompilerUtil.toChunkGraph(ModuleCompilerUtil.createGraphGenerator(models)).getNodes();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/ModuleCompilerUtil", "buildChunks"));
        }
        return collection;
    }

    @NotNull
    public static List<Chunk<ModuleSourceSet>> getCyclicDependencies(@NotNull Project project, @NotNull List<Module> modules) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/ModuleCompilerUtil", "getCyclicDependencies"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/compiler/ModuleCompilerUtil", "getCyclicDependencies"));
        }
        List<Chunk<ModuleSourceSet>> chunks = ModuleCompilerUtil.computeSourceSetCycles(new DefaultModulesProvider(project));
        HashSet<Module> modulesSet = new HashSet<Module>(modules);
        List list = ContainerUtil.filter(chunks, chunk -> {
            for (ModuleSourceSet sourceSet : chunk.getNodes()) {
                if (!modulesSet.contains(sourceSet.getModule())) continue;
                return true;
            }
            return false;
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/ModuleCompilerUtil", "getCyclicDependencies"));
        }
        return list;
    }

    @NotNull
    private static Graph<ModuleSourceSet> createModuleSourceDependenciesGraph(final @NotNull RootModelProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/compiler/ModuleCompilerUtil", "createModuleSourceDependenciesGraph"));
        }
        Graph graph = GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new InboundSemiGraph<ModuleSourceSet>(){

            public Collection<ModuleSourceSet> getNodes() {
                Module[] modules = provider.getModules();
                ArrayList<ModuleSourceSet> result = new ArrayList<ModuleSourceSet>(modules.length * 2);
                for (Module module : modules) {
                    result.add(new ModuleSourceSet(module, ModuleSourceSet.Type.PRODUCTION));
                    result.add(new ModuleSourceSet(module, ModuleSourceSet.Type.TEST));
                }
                return result;
            }

            public Iterator<ModuleSourceSet> getIn(ModuleSourceSet n) {
                ModuleRootModel model = provider.getRootModel(n.getModule());
                OrderEnumerator enumerator = model.orderEntries().compileOnly();
                if (n.getType() == ModuleSourceSet.Type.PRODUCTION) {
                    enumerator = enumerator.productionOnly();
                }
                ArrayList<ModuleSourceSet> deps = new ArrayList<ModuleSourceSet>();
                enumerator.forEachModule((Processor<Module>)((Processor)module -> {
                    deps.add(new ModuleSourceSet((Module)module, n.getType()));
                    return true;
                }));
                if (n.getType() == ModuleSourceSet.Type.TEST) {
                    deps.add(new ModuleSourceSet(n.getModule(), ModuleSourceSet.Type.PRODUCTION));
                }
                return deps.iterator();
            }
        }));
        if (graph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/ModuleCompilerUtil", "createModuleSourceDependenciesGraph"));
        }
        return graph;
    }

    @NotNull
    public static List<Chunk<ModuleSourceSet>> computeSourceSetCycles(@NotNull ModulesProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/compiler/ModuleCompilerUtil", "computeSourceSetCycles"));
        }
        Graph<ModuleSourceSet> graph = ModuleCompilerUtil.createModuleSourceDependenciesGraph(provider);
        Collection<Chunk<ModuleSourceSet>> chunks = GraphAlgorithms.getInstance().computeStronglyConnectedComponents(graph);
        List<Chunk<ModuleSourceSet>> list = ModuleCompilerUtil.removeSingleElementChunks(ModuleCompilerUtil.removeDummyNodes(ModuleCompilerUtil.filterDuplicates(ModuleCompilerUtil.removeSingleElementChunks(chunks)), provider));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/ModuleCompilerUtil", "computeSourceSetCycles"));
        }
        return list;
    }

    private static List<Chunk<ModuleSourceSet>> removeDummyNodes(List<Chunk<ModuleSourceSet>> chunks, ModulesProvider modulesProvider) {
        ArrayList<Chunk<ModuleSourceSet>> result = new ArrayList<Chunk<ModuleSourceSet>>(chunks.size());
        for (Chunk<ModuleSourceSet> chunk : chunks) {
            LinkedHashSet<ModuleSourceSet> nodes = new LinkedHashSet<ModuleSourceSet>();
            for (ModuleSourceSet sourceSet : chunk.getNodes()) {
                if (ModuleCompilerUtil.isDummy(sourceSet, modulesProvider)) continue;
                nodes.add(sourceSet);
            }
            result.add((Chunk<ModuleSourceSet>)new Chunk(nodes));
        }
        return result;
    }

    private static boolean isDummy(ModuleSourceSet set, ModulesProvider modulesProvider) {
        JavaSourceRootType type = set.getType() == ModuleSourceSet.Type.PRODUCTION ? JavaSourceRootType.SOURCE : JavaSourceRootType.TEST_SOURCE;
        ModuleRootModel rootModel = modulesProvider.getRootModel(set.getModule());
        for (ContentEntry entry : rootModel.getContentEntries()) {
            if (entry.getSourceFolders(type).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static List<Chunk<ModuleSourceSet>> removeSingleElementChunks(Collection<Chunk<ModuleSourceSet>> chunks) {
        return ContainerUtil.filter(chunks, chunk -> chunk.getNodes().size() > 1);
    }

    @NotNull
    private static List<Chunk<ModuleSourceSet>> filterDuplicates(@NotNull Collection<Chunk<ModuleSourceSet>> sourceSetCycles) {
        if (sourceSetCycles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSetCycles", "com/intellij/compiler/ModuleCompilerUtil", "filterDuplicates"));
        }
        ArrayList<Set<Module>> productionCycles = new ArrayList<Set<Module>>();
        for (Chunk<ModuleSourceSet> cycle : sourceSetCycles) {
            ModuleSourceSet.Type type = ModuleCompilerUtil.getCommonType(cycle);
            if (type != ModuleSourceSet.Type.PRODUCTION) continue;
            productionCycles.add(ModuleSourceSet.getModules(cycle.getNodes()));
        }
        List list = ContainerUtil.filter(sourceSetCycles, chunk -> {
            if (ModuleCompilerUtil.getCommonType((Chunk<ModuleSourceSet>)chunk) != ModuleSourceSet.Type.TEST) {
                return true;
            }
            for (Set productionCycle : productionCycles) {
                if (!productionCycle.containsAll(ModuleSourceSet.getModules(chunk.getNodes()))) continue;
                return false;
            }
            return true;
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/ModuleCompilerUtil", "filterDuplicates"));
        }
        return list;
    }

    @Nullable
    private static ModuleSourceSet.Type getCommonType(@NotNull Chunk<ModuleSourceSet> cycle) {
        if (cycle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cycle", "com/intellij/compiler/ModuleCompilerUtil", "getCommonType"));
        }
        ModuleSourceSet.Type type = null;
        for (ModuleSourceSet set : cycle.getNodes()) {
            if (type == null) {
                type = set.getType();
                continue;
            }
            if (type == set.getType()) continue;
            return null;
        }
        return type;
    }
}

