/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.RunProfileStarter;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.BaseProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public abstract class AsyncGenericProgramRunner<Settings extends RunnerSettings>
extends BaseProgramRunner<Settings> {
    @Override
    protected final void execute(@NotNull ExecutionEnvironment environment, @Nullable ProgramRunner.Callback callback, @NotNull RunProfileState state) throws ExecutionException {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/runners/AsyncGenericProgramRunner", "execute"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/execution/runners/AsyncGenericProgramRunner", "execute"));
        }
        this.prepare(environment, state).done((Consumer<RunProfileStarter>)((Consumer)result -> {
            if (environment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/runners/AsyncGenericProgramRunner", "lambda$execute$1"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/execution/runners/AsyncGenericProgramRunner", "lambda$execute$1"));
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                if (environment == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/runners/AsyncGenericProgramRunner", "lambda$null$0"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/execution/runners/AsyncGenericProgramRunner", "lambda$null$0"));
                }
                if (!environment.getProject().isDisposed()) {
                    AsyncGenericProgramRunner.startRunProfile(environment, state, callback, result);
                }
            });
        }));
    }

    @NotNull
    protected abstract Promise<RunProfileStarter> prepare(@NotNull ExecutionEnvironment var1, @NotNull RunProfileState var2) throws ExecutionException;

    private static void startRunProfile(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state, final @Nullable ProgramRunner.Callback callback, final @Nullable RunProfileStarter starter) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/runners/AsyncGenericProgramRunner", "startRunProfile"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/execution/runners/AsyncGenericProgramRunner", "startRunProfile"));
        }
        ExecutionManager.getInstance(environment.getProject()).startRunProfile(new RunProfileStarter(){

            @Override
            public Promise<RunContentDescriptor> executeAsync(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/execution/runners/AsyncGenericProgramRunner$1", "executeAsync"));
                }
                if (environment == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/runners/AsyncGenericProgramRunner$1", "executeAsync"));
                }
                if (starter == null) {
                    return Promise.resolve(BaseProgramRunner.postProcess(environment, null, callback));
                }
                return starter.executeAsync(state, environment).then(descriptor -> {
                    if (environment == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/runners/AsyncGenericProgramRunner$1", "lambda$executeAsync$0"));
                    }
                    return BaseProgramRunner.postProcess(environment, descriptor, callback);
                });
            }

            @Override
            public RunContentDescriptor execute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/execution/runners/AsyncGenericProgramRunner$1", "execute"));
                }
                if (environment == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/runners/AsyncGenericProgramRunner$1", "execute"));
                }
                return BaseProgramRunner.postProcess(environment, starter == null ? null : starter.execute(state, environment), callback);
            }
        }, state, environment);
    }
}

