/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.model.common;

import com.intellij.jam.JamElement;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.common.CommonModelTarget;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.pom.PomRenameableTarget;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.MergedObject;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManualModelMergerUtil {
    private ManualModelMergerUtil() {
    }

    public static <T, V> List<T> join(V[] list, Joiner<V, T> joiner) {
        return ManualModelMergerUtil.join(Arrays.asList(list), joiner);
    }

    public static <T, V> List<T> join(Iterable<? extends V> list, Joiner<V, T> joiner) {
        THashSet notToBeMergedSet = new THashSet();
        LinkedHashMap<Object, T> map = new LinkedHashMap<Object, T>();
        for (V v : list) {
            ProgressManager.checkCanceled();
            for (T t : joiner.map(v)) {
                Object key = joiner.key(t);
                Object prev = map.get(key);
                if (notToBeMergedSet.contains(prev)) continue;
                map.put(key, joiner.join(prev, t, notToBeMergedSet));
            }
        }
        return new ArrayList(map.values());
    }

    public static <T, V, X extends T> List<GenericValue<X>> joinValues(Iterable<? extends V> list, final Function<V, Collection<? extends GenericValue<X>>> mapper) {
        return ManualModelMergerUtil.join(list, new Joiner<V, GenericValue<X>>(){

            @Override
            public Collection<? extends GenericValue<X>> map(V v) {
                return (Collection)mapper.fun(v);
            }

            @Override
            public Object key(GenericValue<X> value) {
                return value.getValue();
            }

            @Override
            @NotNull
            public GenericValue<X> join(@Nullable GenericValue<X> prev, GenericValue<X> next, Collection<GenericValue<X>> notToBeMergedSet) {
                GenericValue genericValue = prev == null ? next : (prev instanceof MyGenericValue ? ((MyGenericValue)prev).addImplementation(next) : new MyGenericValue(prev, next));
                if (genericValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/model/common/ManualModelMergerUtil$1", "join"));
                }
                return genericValue;
            }
        });
    }

    public static <T, V, X extends T> GenericValue<X> joinValue(Iterable<? extends V> list, Function<V, GenericValue<X>> mapper) {
        MyGenericValue prev = null;
        for (V v : list) {
            MyGenericValue value = (MyGenericValue)mapper.fun(v);
            if (prev == null) {
                prev = value;
                continue;
            }
            if (prev instanceof MyGenericValue) {
                ((MyGenericValue)prev).addImplementation(value);
                continue;
            }
            prev = new MyGenericValue(prev, value);
        }
        assert (prev != null);
        return prev;
    }

    public static <T, V> T findDom(Iterable<? extends V> list, Function<V, T> mapper, T defValue) {
        for (V v : list) {
            if (!(v instanceof DomElement)) continue;
            return (T)mapper.fun(v);
        }
        return defValue;
    }

    public static <T, V> V findLast(List<? extends T> list, Function<T, V> mapping, V defValue) {
        ListIterator<T> listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            Object v = mapping.fun(listIterator.previous());
            if (v == null) continue;
            return (V)v;
        }
        return defValue;
    }

    public static <T, V, X> X findLast(List<? extends T> list, Function<T, V> mapping, Function<T, X> resultMapping, X defValue) {
        ListIterator<T> listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            T dom = listIterator.previous();
            Object v = mapping.fun(dom);
            if (v == null) continue;
            return (X)resultMapping.fun(dom);
        }
        return defValue;
    }

    private static <T extends CommonModelElement> List<PomTarget> getPomTargets(MyMergedObject<T> object) {
        return ContainerUtil.mapNotNull(object.getImplementations(), (Function)((NullableFunction)t -> {
            PsiElement element = t.getIdentifyingPsiElement();
            if (element instanceof PomTarget) {
                return (PomTarget)((Object)element);
            }
            if (element instanceof PomTargetPsiElement) {
                return ((PomTargetPsiElement)element).getTarget();
            }
            return null;
        }));
    }

    public static class MyGenericValue<T>
    implements MergedObject<GenericValue<? extends T>>,
    GenericValue<T> {
        final List<GenericValue<? extends T>> myTs;

        MyGenericValue(GenericValue<? extends T> ... ts) {
            assert (ts.length > 0);
            this.myTs = new ArrayList<GenericValue<? extends T>>(ts.length);
            ContainerUtil.addAll(this.myTs, (Object[])ts);
        }

        @Override
        public List<GenericValue<? extends T>> getImplementations() {
            return this.myTs;
        }

        public GenericValue<T> addImplementation(GenericValue<T> next) {
            this.myTs.add(next);
            return this;
        }

        @Override
        public String getStringValue() {
            return ManualModelMergerUtil.findLast(this.myTs, value -> value.getStringValue(), null);
        }

        @Override
        public T getValue() {
            return ManualModelMergerUtil.findLast(this.myTs, value -> {
                if (value instanceof DomElement && !DomUtil.hasXml((DomElement)((Object)value))) {
                    return null;
                }
                return value.getValue();
            }, null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyGenericValue value = (MyGenericValue)o;
            return this.myTs.equals(value.myTs);
        }

        public int hashCode() {
            return this.myTs.hashCode();
        }
    }

    public static class MyRenameableTarget
    extends MyTarget<PomRenameableTarget>
    implements PomRenameableTarget<MyRenameableTarget> {
        public MyRenameableTarget(CommonModelElement object, List<PomRenameableTarget> targets) {
            super(object, targets);
        }

        @Override
        public boolean isWritable() {
            for (PomRenameableTarget target : this.myTargets) {
                if (target.isWritable()) continue;
                return false;
            }
            return true;
        }

        @Override
        public MyRenameableTarget setName(@NotNull String newName) {
            if (newName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/jam/model/common/ManualModelMergerUtil$MyRenameableTarget", "setName"));
            }
            ArrayList<PomRenameableTarget> list = new ArrayList<PomRenameableTarget>(this.myTargets.size());
            for (PomRenameableTarget target : this.myTargets) {
                Object result = target.setName(newName);
                if (!(result instanceof PomRenameableTarget)) continue;
                list.add((PomRenameableTarget)result);
            }
            return new MyRenameableTarget(this.getCommonElement(), (List<PomRenameableTarget>)list);
        }

        @Override
        public String getName() {
            PomRenameableTarget target = ManualModelMergerUtil.findLast(this.myTargets, target1 -> target1.getName() != null ? target1 : null, null);
            return target == null ? null : target.getName();
        }
    }

    public static class MyTarget<T extends PomTarget>
    implements MergedObject<T>,
    CommonModelTarget {
        private final CommonModelElement myObject;
        protected final List<T> myTargets;

        public MyTarget(CommonModelElement object, List<T> targets) {
            this.myObject = object;
            this.myTargets = targets;
        }

        @Override
        public CommonModelElement getCommonElement() {
            return this.myObject;
        }

        @Override
        public boolean isValid() {
            for (PomTarget target : this.myTargets) {
                if (target.isValid()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void navigate(boolean requestFocus) {
            PomTarget target = ManualModelMergerUtil.findLast(this.myTargets, new NullableFunction<PomTarget, PomTarget>(){

                public PomTarget fun(PomTarget target) {
                    return target.canNavigate() ? target : null;
                }
            }, null);
            if (target != null) {
                target.navigate(requestFocus);
            }
        }

        @Override
        public boolean canNavigate() {
            return ManualModelMergerUtil.findLast(this.myTargets, new NullableFunction<PomTarget, PomTarget>(){

                public PomTarget fun(PomTarget target) {
                    return target.canNavigate() ? target : null;
                }
            }, null) != null;
        }

        @Override
        public boolean canNavigateToSource() {
            return ManualModelMergerUtil.findLast(this.myTargets, new NullableFunction<PomTarget, PomTarget>(){

                public PomTarget fun(PomTarget target) {
                    return target.canNavigateToSource() ? target : null;
                }
            }, null) != null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PomTarget)) {
                return false;
            }
            PomTarget target = (PomTarget)o;
            if (target instanceof MyTarget) {
                return this.myTargets.equals(((MyTarget)target).myTargets);
            }
            return this.myTargets.contains(target);
        }

        public int hashCode() {
            return this.myTargets.hashCode();
        }

        @Override
        @NotNull
        public PsiElement getNavigationElement() {
            PsiElement psiElement = ManualModelMergerUtil.findLast(this.myTargets, t -> t instanceof PsiTarget ? ((PsiTarget)t).getNavigationElement() : null, null);
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/model/common/ManualModelMergerUtil$MyTarget", "getNavigationElement"));
            }
            return psiElement;
        }

        @Override
        public List<T> getImplementations() {
            return this.myTargets;
        }
    }

    public static class MyMergedObject<T extends CommonModelElement>
    implements MergedObject<T>,
    CommonModelElement {
        protected final List<T> myTs;

        protected MyMergedObject(T ... ts) {
            assert (ts.length > 0);
            this.myTs = new ArrayList<T>(ts.length);
            ContainerUtil.addAll(this.myTs, (Object[])ts);
        }

        protected MyMergedObject(List<T> ts) {
            assert (!ts.isEmpty());
            this.myTs = ts;
        }

        @Override
        public List<T> getImplementations() {
            return this.myTs;
        }

        public T addImplementation(T next) {
            this.myTs.add(next);
            return (T)this;
        }

        @Override
        public boolean isValid() {
            for (CommonModelElement t : this.myTs) {
                if (t.isValid()) continue;
                return false;
            }
            return true;
        }

        @Override
        public XmlTag getXmlTag() {
            return ManualModelMergerUtil.findDom(this.myTs, t -> t.getXmlTag(), null);
        }

        @Override
        public PsiManager getPsiManager() {
            return ((CommonModelElement)this.myTs.get(0)).getPsiManager();
        }

        @Override
        public Module getModule() {
            for (CommonModelElement t : this.myTs) {
                Module module;
                PsiElement element = t.getIdentifyingPsiElement();
                if (element == null || (module = ModuleUtil.findModuleForPsiElement(element)) == null) continue;
                return module;
            }
            return null;
        }

        @Override
        public PsiElement getIdentifyingPsiElement() {
            if (this.myTs.size() == 1) {
                return ((CommonModelElement)this.myTs.get(0)).getIdentifyingPsiElement();
            }
            List targets = ManualModelMergerUtil.getPomTargets(this);
            if (targets.isEmpty()) {
                return ((CommonModelElement)this.myTs.get(0)).getIdentifyingPsiElement();
            }
            boolean notRenameable = false;
            for (PomTarget target : targets) {
                if (target instanceof PomRenameableTarget) continue;
                notRenameable = true;
                break;
            }
            MyTarget target = targets.size() == 1 ? (MyTarget)targets.get(0) : (notRenameable ? new MyTarget(this, targets) : new MyRenameableTarget((CommonModelElement)this, targets));
            return PomService.convertToPsi(this.getPsiManager().getProject(), target);
        }

        @Override
        public PsiFile getContainingFile() {
            PsiElement element = this.getIdentifyingPsiElement();
            return element == null ? null : element.getContainingFile();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyMergedObject object = (MyMergedObject)o;
            return this.myTs.equals(object.myTs);
        }

        public int hashCode() {
            return this.myTs.hashCode();
        }
    }

    public static abstract class AnnoJoiner<V, T extends CommonModelElement, Psi extends PsiMember>
    implements Joiner<V, T> {
        @Override
        @NotNull
        public final T join(@Nullable T prev, T next, Collection<T> notToBeMergedSet) {
            if (this.shouldNotBeMerged(next)) {
                notToBeMergedSet.add(next);
                T t = next;
                if (t == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/model/common/ManualModelMergerUtil$AnnoJoiner", "join"));
                }
                return t;
            }
            T t = this.joinInner(prev, next);
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/model/common/ManualModelMergerUtil$AnnoJoiner", "join"));
            }
            return t;
        }

        @NotNull
        protected T joinInner(@Nullable T prev, T next) {
            T anno;
            if (prev instanceof MyMergedObject) {
                T t = ((MyMergedObject)prev).addImplementation(next);
                if (t == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/model/common/ManualModelMergerUtil$AnnoJoiner", "joinInner"));
                }
                return t;
            }
            if (prev != null) {
                T t = this.createMergedImplementation(prev, next);
                if (t == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/model/common/ManualModelMergerUtil$AnnoJoiner", "joinInner"));
                }
                return t;
            }
            if (next instanceof JamElement) {
                T t = next;
                if (t == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/model/common/ManualModelMergerUtil$AnnoJoiner", "joinInner"));
                }
                return t;
            }
            Psi psiMember = this.getPsiMember(next);
            if (psiMember == null || (anno = this.getCurrentJam(next, psiMember)) == null) {
                T t = next;
                if (t == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/model/common/ManualModelMergerUtil$AnnoJoiner", "joinInner"));
                }
                return t;
            }
            T t = this.createMergedImplementation(anno, next);
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/model/common/ManualModelMergerUtil$AnnoJoiner", "joinInner"));
            }
            return t;
        }

        @Nullable
        protected abstract T getCurrentJam(T var1, Psi var2);

        @NotNull
        protected abstract T createMergedImplementation(T var1, T var2);

        @Nullable
        protected abstract Psi getPsiMember(T var1);

        protected boolean shouldNotBeMerged(T element) {
            return false;
        }
    }

    public static abstract class NextJoiner<V, T>
    implements Joiner<V, T> {
        @Override
        @NotNull
        public final T join(@Nullable T prev, T next, Collection<T> notToBeMergedSet) {
            T t = next;
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/model/common/ManualModelMergerUtil$NextJoiner", "join"));
            }
            return t;
        }
    }

    public static abstract class SimpleJoiner<V, T extends CommonModelElement>
    implements Joiner<V, T> {
        @Override
        @NotNull
        public final T join(@Nullable T prev, T next, Collection<T> notToBeMergedSet) {
            T t = prev == null ? next : (prev instanceof MyMergedObject ? ((MyMergedObject)prev).addImplementation(next) : this.createMergedImplementation(prev, next));
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/model/common/ManualModelMergerUtil$SimpleJoiner", "join"));
            }
            return t;
        }

        @NotNull
        protected abstract T createMergedImplementation(T var1, T var2);
    }

    public static interface Joiner<V, T> {
        public Collection<? extends T> map(V var1);

        @Nullable
        public Object key(T var1);

        @NotNull
        public T join(@Nullable T var1, T var2, Collection<T> var3);
    }
}

