/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.reflect;

import com.intellij.jam.JamConverter;
import com.intellij.jam.JamElement;
import com.intellij.jam.reflect.JamAnnotationAttributeMeta;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamBooleanAttributeMeta;
import com.intellij.jam.reflect.JamClassAttributeMeta;
import com.intellij.jam.reflect.JamEnumAttributeMeta;
import com.intellij.jam.reflect.JamInstantiator;
import com.intellij.jam.reflect.JamNumberAttributeMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.jam.reflect.JamTypeAttributeMeta;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.ref.AnnotationAttributeChildLink;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class JamAttributeMeta<JamType> {
    private final AnnotationAttributeChildLink myAttributeLink;

    protected JamAttributeMeta(@NonNls String attrName) {
        this.myAttributeLink = new AnnotationAttributeChildLink(attrName);
    }

    public AnnotationAttributeChildLink getAttributeLink() {
        return this.myAttributeLink;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JamAttributeMeta that = (JamAttributeMeta)o;
        return this.myAttributeLink.equals(that.myAttributeLink);
    }

    public int hashCode() {
        return this.myAttributeLink.hashCode();
    }

    @NotNull
    protected <T> List<T> getCollectionJam(PsiElementRef<PsiAnnotation> annoRef, NullableFunction<PsiAnnotationMemberValue, T> producer) {
        PsiAnnotationMemberValue attr = this.getAttributeLink().findLinkedChild(annoRef.getPsiElement());
        if (attr == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/reflect/JamAttributeMeta", "getCollectionJam"));
            }
            return list;
        }
        ArrayList result = new ArrayList();
        if (attr instanceof PsiArrayInitializerMemberValue) {
            for (PsiAnnotationMemberValue value : ((PsiArrayInitializerMemberValue)attr).getInitializers()) {
                ContainerUtil.addIfNotNull(result, (Object)producer.fun((Object)value));
            }
        } else {
            ContainerUtil.addIfNotNull(result, (Object)producer.fun((Object)attr));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/reflect/JamAttributeMeta", "getCollectionJam"));
        }
        return arrayList;
    }

    @NotNull
    public abstract JamType getJam(PsiElementRef<PsiAnnotation> var1);

    public static JamStringAttributeMeta.Single<String> singleString(@NotNull @NonNls String attrName) {
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/intellij/jam/reflect/JamAttributeMeta", "singleString"));
        }
        return JamAttributeMeta.singleString(attrName, JamConverter.DUMMY_CONVERTER);
    }

    public static <T> JamStringAttributeMeta.Single<T> singleString(@NotNull @NonNls String attrName, JamConverter<T> converter) {
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/intellij/jam/reflect/JamAttributeMeta", "singleString"));
        }
        return new JamStringAttributeMeta.Single<T>(attrName, converter);
    }

    public static <T extends Enum<T>> JamEnumAttributeMeta.Single<T> singleEnum(@NotNull @NonNls String attrName, Class<T> modelEnum) {
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/intellij/jam/reflect/JamAttributeMeta", "singleEnum"));
        }
        return new JamEnumAttributeMeta.Single<T>(attrName, modelEnum);
    }

    public static JamStringAttributeMeta.Collection<String> collectionString(@NotNull @NonNls String attrName) {
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/intellij/jam/reflect/JamAttributeMeta", "collectionString"));
        }
        return JamAttributeMeta.collectionString(attrName, JamConverter.DUMMY_CONVERTER);
    }

    public static <T> JamStringAttributeMeta.Collection<T> collectionString(String attrName, JamConverter<T> converter) {
        return new JamStringAttributeMeta.Collection<T>(attrName, converter);
    }

    public static <T extends JamElement> JamAnnotationAttributeMeta.Single<T> singleAnno(@NotNull @NonNls String attrName, JamAnnotationMeta annoMeta, Class<T> jamClass) {
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/intellij/jam/reflect/JamAttributeMeta", "singleAnno"));
        }
        JamInstantiator instantiator = JamInstantiator.proxied(jamClass);
        return new JamAnnotationAttributeMeta.Single<T>(attrName, annoMeta, instantiator);
    }

    public static <T extends JamElement> JamAnnotationAttributeMeta.Collection<T> annoCollection(@NotNull @NonNls String attrName, @NotNull JamAnnotationMeta annoMeta, Class<T> jamClass) {
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/intellij/jam/reflect/JamAttributeMeta", "annoCollection"));
        }
        if (annoMeta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annoMeta", "com/intellij/jam/reflect/JamAttributeMeta", "annoCollection"));
        }
        JamInstantiator instantiator = JamInstantiator.proxied(jamClass);
        return new JamAnnotationAttributeMeta.Collection<T>(attrName, annoMeta, instantiator);
    }

    public static JamClassAttributeMeta.Single singleClass(String attrName) {
        return new JamClassAttributeMeta.Single(attrName);
    }

    public static JamClassAttributeMeta.Collection classCollection(String attrName) {
        return new JamClassAttributeMeta.Collection(attrName);
    }

    public static JamTypeAttributeMeta.Single singleType(String attrName) {
        return new JamTypeAttributeMeta.Single(attrName);
    }

    public static JamTypeAttributeMeta.Collection typeCollection(String attrName) {
        return new JamTypeAttributeMeta.Collection(attrName);
    }

    public static JamBooleanAttributeMeta singleBoolean(@NotNull @NonNls String attrName, boolean defaultValue) {
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/intellij/jam/reflect/JamAttributeMeta", "singleBoolean"));
        }
        return new JamBooleanAttributeMeta(attrName, defaultValue);
    }

    public static JamNumberAttributeMeta.Single<Integer> singleInteger(@NotNull @NonNls String attrName) {
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/intellij/jam/reflect/JamAttributeMeta", "singleInteger"));
        }
        return new JamNumberAttributeMeta.Single<Integer>(attrName, Integer.class);
    }

    protected static PsiAnnotationMemberValue addAttribute(PsiElementRef<PsiAnnotation> annoRef, String valueText, AnnotationAttributeChildLink link) {
        PsiAnnotation annotation = annoRef.ensurePsiElementExists();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory(annotation.getProject());
        PsiAnnotationMemberValue literal = factory.createExpressionFromText(valueText, null);
        PsiAnnotationMemberValue attr = link.findLinkedChild(annotation);
        if (attr == null) {
            literal = (PsiAnnotationMemberValue)link.createChild(annotation).replace(literal);
        } else if (attr instanceof PsiArrayInitializerMemberValue) {
            literal = (PsiAnnotationMemberValue)attr.add(literal);
        } else {
            PsiAnnotationMemberValue arrayInit = factory.createAnnotationFromText("@Foo({})", null).findDeclaredAttributeValue(null);
            arrayInit.add(attr);
            arrayInit = annotation.setDeclaredAttributeValue(link.getAttributeName(), arrayInit);
            literal = (PsiAnnotationMemberValue)arrayInit.add(literal);
        }
        return literal;
    }
}

