/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VFileCopyEvent
extends VFileEvent {
    private final VirtualFile myFile;
    private final VirtualFile myNewParent;
    private final String myNewChildName;

    public VFileCopyEvent(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile newParent, @NotNull String newChildName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/newvfs/events/VFileCopyEvent", "<init>"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/intellij/openapi/vfs/newvfs/events/VFileCopyEvent", "<init>"));
        }
        if (newChildName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newChildName", "com/intellij/openapi/vfs/newvfs/events/VFileCopyEvent", "<init>"));
        }
        super(requestor, false);
        this.myFile = file;
        this.myNewParent = newParent;
        this.myNewChildName = newChildName;
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile2 = this.myFile;
        if (virtualFile2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/events/VFileCopyEvent", "getFile"));
        }
        return virtualFile2;
    }

    @NotNull
    public VirtualFile getNewParent() {
        VirtualFile virtualFile2 = this.myNewParent;
        if (virtualFile2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/events/VFileCopyEvent", "getNewParent"));
        }
        return virtualFile2;
    }

    @NotNull
    public String getNewChildName() {
        String string = this.myNewChildName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/events/VFileCopyEvent", "getNewChildName"));
        }
        return string;
    }

    @NonNls
    public String toString() {
        return "VfsEvent[copy " + this.myFile + " to " + this.myNewParent + " as " + this.myNewChildName + "]";
    }

    @Override
    @NotNull
    public String getPath() {
        String string = this.myNewParent.getPath() + "/" + this.myNewChildName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/events/VFileCopyEvent", "getPath"));
        }
        return string;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myFile.getFileSystem();
        if (virtualFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/events/VFileCopyEvent", "getFileSystem"));
        }
        return virtualFileSystem;
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid() && this.myNewParent.findChild(this.myNewChildName) == null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFileCopyEvent event = (VFileCopyEvent)o;
        if (!this.myFile.equals(event.myFile)) {
            return false;
        }
        if (!this.myNewChildName.equals(event.myNewChildName)) {
            return false;
        }
        return this.myNewParent.equals(event.myNewParent);
    }

    @Override
    public int hashCode() {
        int result = this.myFile.hashCode();
        result = 31 * result + this.myNewParent.hashCode();
        result = 31 * result + this.myNewChildName.hashCode();
        return result;
    }
}

